<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title', ['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' =>__($page_title),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="table-area">
        <div class="table-wrapper">
            <div class="table-header">
                <h5 class="title"><?php echo e(__($page_title)); ?></h5>
                <?php if(count($transactions) > 0): ?>
                    <div class="table-btn-area">
                        <a href="<?php echo e(setRoute('admin.payment.link.export.data')); ?>" class="btn--base py-2 px-4"><i class="fas fa-download me-1"></i><?php echo e(__("Export Data")); ?></a>
                    </div>
                <?php endif; ?>

            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__("web_trx_id")); ?></th>
                            <th><?php echo e(__("type")); ?></th>
                            <th><?php echo e(__("User Type")); ?></th>
                            <th><?php echo e(__("Email")); ?></th>
                            <th><?php echo e(__("Payment Type")); ?></th>
                            <th><?php echo e(__("Amount")); ?></th>
                            <th><?php echo e(__("Payable")); ?></th>
                            <th><?php echo e(__("Conversion Payable")); ?></th>
                            <th><?php echo e(__("Status")); ?></th>
                            <th><?php echo e(__("Time")); ?></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($item->trx_id); ?></td>
                                <td><span class="text--info"><?php echo e($item->type); ?></span></td>
                                <td>
                                    <?php if($item->user_id != null): ?>
                                         <?php echo e(__("USER")); ?>

                                    <?php elseif($item->merchant_id != null): ?>
                                         <?php echo e(__("MERCHANT")); ?>

                                    <?php endif; ?>

                                </td>
                                <td>
                                    <?php if($item->user_id != null): ?>
                                    <a href="<?php echo e(setRoute('admin.users.details',$item->creator->username)); ?>"><?php echo e($item->creator->email??"N/A"); ?></a>
                                    <?php elseif($item->merchant_id != null): ?>
                                    <a href="<?php echo e(setRoute('admin.merchants.details',$item->creator->username)); ?>"><?php echo e($item->creator->email??"N/A"); ?></a>
                                    <?php endif; ?>
                                </td>

                                <td><?php echo e(ucwords(str_replace('_',' ',$item->details->payment_type??__('Card Payment')) )); ?></td>
                                <td><?php echo e(get_amount(@$item->request_amount, @$item->details->charge_calculation->sender_cur_code)); ?></td>
                                <td><?php echo e(get_amount(@$item->payable, @$item->details->charge_calculation->sender_cur_code)); ?></td>
                                <td><?php echo e(get_amount(@$item->details->charge_calculation->conversion_payable, @$item->details->charge_calculation->receiver_currency_code)); ?></td>
                                <td>
                                    <span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?></span>
                                </td>
                                <td><?php echo e(dateFormat('d M y h:i:s A', $item->created_at)); ?></td>
                                <td>
                                    <?php if($item->status == 0): ?>
                                        <button type="button" class="btn btn--base bg--success"><i
                                                class="las la-check-circle"></i></button>
                                        <button type="button" class="btn btn--base bg--danger"><i
                                                class="las la-times-circle"></i></button>
                                        <a href="add-logs-edit.html" class="btn btn--base"><i class="las la-expand"></i></a>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($item->type == 'PAY-INVOICE'): ?>
                                        <?php echo $__env->make('admin.components.link.info-default',[
                                            'href'          => setRoute('admin.invoice.details', $item->id),
                                            'permission'    => "admin.invoice.details",
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php else: ?>
                                        <?php echo $__env->make('admin.components.link.info-default',[
                                            'href'          => setRoute('admin.payment.link.details', $item->id),
                                            'permission'    => "admin.payment.link.details",
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php endif; ?>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php echo $__env->make('admin.components.alerts.empty',['colspan' => 10], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo e(get_paginate($transactions)); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp-8.0.2\htdocs\qrpay\v4.5.0\full_project\resources\views/admin/sections/payment-link/index.blade.php ENDPATH**/ ?>