@extends('user.layouts.master')

@push('css')

@endpush

@section('breadcrumb')
    @include('user.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("user.dashboard"),
        ]
    ], 'active' => __(@$page_title)])
@endsection

@section('content')
<div class="body-wrapper">
    <div class="dashboard-area mt-10">
        <div class="dashboard-header-wrapper">
            <h3 class="title">{{__($page_title)}}</h3>
        </div>
    </div>
    <div class="row mb-30-none">
        <div class="col-lg-6 mb-30">
            <div class="dash-payment-item-wrapper">
                <div class="dash-payment-item active">
                    <div class="dash-payment-title-area">
                        <span class="dash-payment-badge">!</span>
                        <h5 class="title">{{ __($page_title) }}</h5>
                    </div>
                    <div class="dash-payment-body">
                        <form class="card-form" action="{{ setRoute('user.money.out.insert') }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-xl-12 col-lg-12 form-group text-center">
                                    <div class="exchange-area">
                                        <code class="d-block text-center"><span>{{ __("Exchange Rate") }}</span> <span class="rate-show">--</span></code>
                                    </div>
                                </div>
                                <div class="col-xl-6 col-lg-6 form-group">
                                    <label>{{ __("Payment Gateway") }}<span>*</span></label>
                                    <select class="form--control nice-select gateway-select" name="gateway">
                                        @forelse ($payment_gateways ?? [] as $item)
                                            <option
                                                value="{{ $item->alias  }}"
                                                data-currency="{{ $item->currency_code }}"
                                                data-min_amount="{{ $item->min_limit }}"
                                                data-max_amount="{{ $item->max_limit }}"
                                                data-percent_charge="{{ $item->percent_charge }}"
                                                data-fixed_charge="{{ $item->fixed_charge }}"
                                                data-rate="{{ $item->rate }}"
                                                >
                                                {{ $item->name }}
                                            </option>
                                        @empty
                                            <option value="null" disabled  selected>{{ __('No Gateway Available') }}</option>
                                        @endforelse
                                    </select>
                                </div>
                                <div class="col-xl-6 col-lg-6 form-group">

                                    <label>{{ __("Amount") }}<span>*</span></label>
                                    <div class="input-group">
                                        <input type="text" class="form--control" required placeholder="{{ __('enter Amount') }}" name="amount" value="{{ old("amount") }}">
                                        <select class="form--control nice-select currency" name="currency">
                                            @foreach ($wallet_currencies ?? [] as $data)
                                                <option value="{{  $data->code }}" data-rate="{{ $data->rate }}" data-currency-id="{{ $data->id }}" data-sender-country-name="{{ $data->name }}">{{  $data->code }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <code class="d-block mt-10 text-end text--dark fw-bold balance-show">--</code>
                                </div>
                                <div class="col-xl-12 col-lg-12 form-group">
                                    <div class="note-area">
                                        <code class="d-block limit-show">--</code>
                                        <code class="d-block fees-show">--</code>
                                    </div>
                                </div>
                                <div class="col-xl-12 col-lg-12">
                                    <button type="submit" class="btn--base w-100 btn-loading">{{ __("Withdraw Money") }} <i class="fas fa-arrow-alt-circle-right ms-1"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-30">
            <div class="dash-payment-item-wrapper">
                <div class="dash-payment-item active">
                    <div class="dash-payment-title-area">
                        <span class="dash-payment-badge">!</span>
                        <h5 class="title">{{ __($page_title) }} {{__("Preview")}}</h5>
                    </div>
                    <div class="dash-payment-body">
                        <div class="preview-list-wrapper">
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-receipt"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span>{{ __("Entered Amount") }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="request-amount">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="lab la-get-pocket"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span>{{ __("Conversion Amount") }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="conversionAmount">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-battery-half"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span>{{ __("Total Fees & Charges") }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="fees">--</span>
                                </div>
                            </div>

                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-money-check-alt"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span class="">{{ __("Will Get") }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="text--success will-get">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-money-check-alt"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span class="last">{{ __("Payable Amount") }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="text--warning last total-pay">--</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="dashboard-list-area mt-20">
        <div class="dashboard-header-wrapper">
            <h4 class="title ">{{__("withdraw Log")}}</h4>
            <div class="dashboard-btn-wrapper">
                <div class="dashboard-btn mb-2">
                    <a href="{{ setRoute('user.transactions.index','withdraw') }}" class="btn--base">{{__("View More")}}</a>
                </div>
            </div>
        </div>
        <div class="dashboard-list-wrapper">
            @include('user.components.transaction-log',compact("transactions"))
        </div>
    </div>
</div>
@endsection

@push('script')
    <script>
         var defualCurrency = "{{ get_default_currency_code() }}";
         var defualCurrencyRate = "{{ get_default_currency_rate() }}";

        $('select[name=gateway]').on('change',function(){
            getExchangeRate();
            getLimit();
            getFees();
            activeItems();
        });
        $('select[name=currency]').on('change',function(){
            walletBalance();
            getExchangeRate();
            getLimit();
            getFees();
            activeItems();
        });
        $(document).ready(function(){
            walletBalance();
            getExchangeRate();
            getLimit();
            getFees();
            activeItems();
        });
        $("input[name=amount]").keyup(function(){
             getFees();
             activeItems();
        });

        function acceptVar(){
            var selectedVal             = $("select[name=gateway] :selected");
            var currencyCode            = $("select[name=gateway] :selected").attr("data-currency");
            var currencyRate            = $("select[name=gateway] :selected").attr("data-rate");
            var currencyMinAmount       = $("select[name=gateway] :selected").attr("data-min_amount");
            var currencyMaxAmount       = $("select[name=gateway] :selected").attr("data-max_amount");
            var currencyFixedCharge     = $("select[name=gateway] :selected").attr("data-fixed_charge");
            var currencyPercentCharge   = $("select[name=gateway] :selected").attr("data-percent_charge");

            var wCurrencyVal            = $("select[name=currency] :selected");
            var wCurrencyCode            = $("select[name=currency] :selected").val();
            var wCurrencyRate            = $("select[name=currency] :selected").data('rate');

            return {
                currencyCode:currencyCode,
                currencyRate:currencyRate,
                currencyMinAmount:currencyMinAmount,
                currencyMaxAmount:currencyMaxAmount,
                currencyFixedCharge:currencyFixedCharge,
                currencyPercentCharge:currencyPercentCharge,
                selectedVal:selectedVal,

                wCurrencyVal:wCurrencyVal,
                wCurrencyCode:wCurrencyCode,
                wCurrencyRate:wCurrencyRate,

            };
        }
        function getExchangeRate() {
            if(acceptVar().selectedVal.val() === "null"){
                return false;
            }
            var gCurrencyCode = acceptVar().currencyCode;
            var gCurrencyRate = acceptVar().currencyRate;
            var wCurrencyCode = acceptVar().wCurrencyCode;
            var wCurrencyRate = acceptVar().wCurrencyRate;
            var exchange_rate = parseFloat(gCurrencyRate) / parseFloat(wCurrencyRate);
            $('.rate-show').html("1 " + wCurrencyCode + " = " + parseFloat(exchange_rate).toFixed(4) + " " + gCurrencyCode);
            return exchange_rate;
        }
        function getLimit() {
            var exchange_rate = getExchangeRate();
            var wCurrencyCode = acceptVar().wCurrencyCode;
            var wCurrencyRate = acceptVar().wCurrencyRate;
            var min_limit = acceptVar().currencyMinAmount;
            var max_limit =acceptVar().currencyMaxAmount;

            if($.isNumeric(min_limit) || $.isNumeric(max_limit)) {
                var min_limit_calc = parseFloat(min_limit/exchange_rate).toFixed(4);
                var max_limit_clac = parseFloat(max_limit/exchange_rate).toFixed(4);
                $('.limit-show').html("{{ __('limit') }} " + min_limit_calc + " " + wCurrencyCode + " - " + max_limit_clac + " " + wCurrencyCode);
                return {
                    minLimit:min_limit_calc,
                    maxLimit:max_limit_clac,
                };
            }else {
                $('.limit-show').html("--");
                return {
                    minLimit:0,
                    maxLimit:0,
                };
            }
        }
        function feesCalculation() {
            var exchange_rate = getExchangeRate();
            var sender_amount = $("input[name=amount]").val();
            sender_amount == "" ? (sender_amount = 0) : (sender_amount = sender_amount);

            var fixed_charge = acceptVar().currencyFixedCharge;
            var percent_charge = acceptVar().currencyPercentCharge;

            if ($.isNumeric(percent_charge) && $.isNumeric(fixed_charge)) {
                // Process Calculation
                var fixed_charge_calc = parseFloat(fixed_charge) / parseFloat(exchange_rate);
                var percent_charge_calc = (parseFloat(sender_amount) / 100) * parseFloat(percent_charge);
                var total_charge = parseFloat(fixed_charge_calc) + parseFloat(percent_charge_calc);
                total_charge = parseFloat(total_charge).toFixed(4);
                // return total_charge;
                return {
                    total: total_charge,
                    fixed: fixed_charge_calc,
                    percent: percent_charge,
                };
            } else {
                // return "--";
                return false;
            }
        }
        function getFees() {
            var wCurrencyCode = acceptVar().wCurrencyCode;
            var percent = acceptVar().currencyPercentCharge;
            var charges = feesCalculation();
            if (charges == false) {
                return false;
            }
            $(".fees-show").html("{{ __('charge') }}: " + parseFloat(charges.fixed).toFixed(4) + " " + wCurrencyCode + " + " + parseFloat(charges.percent).toFixed(4) + "%");
        }
        function activeItems(){
            var selectedVal = acceptVar().selectedVal.val();
            if(selectedVal === undefined || selectedVal === '' || selectedVal === null){
                return false;
            }else{
                return getPreview();
            }
        }
        function getPreview() {

            var wCurrencyCode = acceptVar().wCurrencyCode;
            var gCurrencyCode = acceptVar().currencyCode;
            var exchange_rate = getExchangeRate();
            var senderAmount = $("input[name=amount]").val();

            if(acceptVar().selectedVal.val() === "null"){
                return false;
            }
            senderAmount == "" ? senderAmount = 0 : senderAmount = senderAmount;

            // Sending Amount
            $('.request-amount').text(senderAmount + " " + wCurrencyCode);

            // Fees
            var charges = feesCalculation();
            var total_charge = 0;
            if(senderAmount == 0){
                total_charge = 0;
            }else{
                total_charge = charges.total;
            }

            $('.fees').text(total_charge + " " + wCurrencyCode);

            var conversionAmount = senderAmount * exchange_rate;
            $('.conversionAmount').text(parseFloat(conversionAmount).toFixed(4) + " " + gCurrencyCode);
            // willget
            var will_get = parseFloat(conversionAmount)
            var will_get_total = 0;
            if(senderAmount == 0){
                    will_get_total = 0;
            }else{
                    will_get_total =  parseFloat(will_get);
            }
            $('.will-get').text(parseFloat(will_get_total).toFixed(4) + " " + gCurrencyCode);

            // total payable
            var totalPay = parseFloat(senderAmount) + parseFloat( total_charge)
            var pay_in_total = 0;
            if(senderAmount == 0){
                    pay_in_total = 0;
            }else{
                //  pay_in_total =  parseFloat(totalPay) + parseFloat(charges.total);
                    pay_in_total =  parseFloat(totalPay);
            }
            $('.total-pay').text(parseFloat(pay_in_total).toFixed(4) + " " + wCurrencyCode);
        }

        function walletBalance(){
            var senderCurrency = acceptVar().wCurrencyCode;
            var csrfToken = $('meta[name="csrf-token"]').attr('content');
            $.ajax({
                type: 'POST',
                url: "{{ route('user.wallets.balance') }}",
                data: {
                    target: senderCurrency,
                    _token: csrfToken
                },
                success: function(response) {
                    $('.balance-show').html("{{ __('Available Balance') }}: " + parseFloat(response.data).toFixed(2) + " " + senderCurrency);
                }
            });
        }
    </script>
@endpush
