
<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('user.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("user.dashboard"),
        ]
    ], 'active' => __(@$page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="body-wrapper">
    <div class="table-area">
        <div class="dashboard-header-wrapper">
            <h4 class="title"><?php echo e($page_title); ?></h4>
            <div class="dashboard-btn-wrapper">
                <div class="dashboard-btn">
                    <a href="<?php echo e(setRoute('user.payment-link.create')); ?>" class="btn--base"><i class="las la-plus me-1"></i> <?php echo e(__('Create Link')); ?></a>
                </div>
            </div>
        </div>
        <div class="table-wrapper">
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__("titleS")); ?></th>
                            <th><?php echo e(__('type')); ?></th>
                            <th><?php echo e(__('Amount')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Created At')); ?></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $payment_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($item->title); ?></td>
                                <td><?php echo e($item->linkType); ?></td>
                                <td><?php echo e($item->amountCalculation); ?></td>
                                <td><span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?></span></td>
                                <td><?php echo e(dateFormat('d M Y , h:i:s A', $item->created_at)); ?></td>
                                <td>
                                    <div class="d-flex justify-content-end">
                                        <button type="button" onclick="copyToClipBoard('copy-share-link-<?php echo e($item->id); ?>')" class="btn--base btn"><i class="las la-clipboard"></i></button>
                                        <input type="hidden" id="copy-share-link-<?php echo e($item->id); ?>" value="<?php echo e(setRoute('payment-link.share', $item->token)); ?>">
                                        <div class="action-btn ms-1">
                                            <button type="button" class="btn--base btn"><i class="las la-ellipsis-v"></i></button>
                                            <ul class="action-list">
                                                <?php if($item->status == 1): ?>
                                                    <li><a href="<?php echo e(setRoute('user.payment-link.edit', $item->id)); ?>"><?php echo e(__("editS")); ?></a></li>
                                                <?php endif; ?>
                                                <?php if($item->status == 1): ?>
                                                    <li><a href="" class="status_change" data-target="<?php echo e($item->id); ?>" data-type="<?php echo e(__("Make Close")); ?>"><?php echo e(__("closeS")); ?></a></li>
                                                <?php else: ?>
                                                    <li><a href="" class="status_change" data-target="<?php echo e($item->id); ?>" data-type="<?php echo e(__("Make Active")); ?>"><?php echo e(__("active")); ?></a></li>
                                                <?php endif; ?>
                                            </ul>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php echo $__env->make('admin.components.alerts.empty2',['colspan' => 7], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <nav>
           <?php echo e($payment_links->links()); ?>

        </nav>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    function copyToClipBoard(element) {
        var copyText = document.getElementById(element);
        copyText.select();
        navigator.clipboard.writeText(copyText.value);
        notification('success', 'URL Copied To Clipboard!');
    }
    $(".status_change").click(function(e){
        e.preventDefault();
        var target  = $(this).data('target');
        var actionRoute = "<?php echo e(route('user.payment-link.status')); ?>";
        var firstText = '<?php echo e(__("Are you sure to change")); ?>';
        var status = "<?php echo e(__('Status')); ?>";
        var message = `${firstText} <strong>${status}</strong>?`;
        var type = $(this).data('type');
        openAlertModal(actionRoute,target,message,type,"POST");
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp-8.0.2\htdocs\simple-pay\resources\views/user/sections/payment-link/index.blade.php ENDPATH**/ ?>