<?php
    $lang = selectedLang();
    $about_slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::ABOUT_SECTION);
    $about = App\Models\Admin\SiteSections::getData($about_slug)->first();

?>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start about section
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<section class="about-section pt-120">
    <div class="container">
        <div class="row mb-30-none align-items-center">
            <div class="col-xl-6 col-lg-6 col-md-6 mb-30">
                <div class="about-thumb-area">
                    <div class="about-thumb">
                        <img src="<?php echo e(get_image(@$about->value->images->image,'site-section')); ?>" alt="about">
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-lg-6 col-md-6 mb-30">
                <div class="about-content-area">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="section-header">
                                <span class="section-sub-titel"><i class="fas fa-qrcode"></i><?php echo e(__(@$about->value->language->$lang->heading)); ?></span>
                                <h2 class="section-title"><?php echo e(__(@$about->value->language->$lang->sub_heading)); ?></h2>
                                <p><?php echo e(__(@$about->value->language->$lang->details)); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="about-item-wrapper">
                        <?php if(isset($about->value->items)): ?>
                        <?php
                            $numKey = 0;
                        ?>
                        <?php $__currentLoopData = $about->value->items ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $numKey += 1;
                        ?>
                        <div class="about-content-item">
                            <div class="icon-area <?php echo e($numKey == 1 ?'active':''); ?>">
                                <i class="<?php echo e(@$item->language->$lang->icon); ?> "></i>
                            </div>
                            <div class="title-area">
                                <h4 class="title"><?php echo e(__(@$item->language->$lang->title )); ?></h4>
                                <span class="sub-title"><?php echo e(__( @$item->language->$lang->sub_title)); ?></span>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End about section
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<?php /**PATH E:\xampp-8.0.2\htdocs\qrpay\v4.5.0\multiple\resources\views/frontend/partials/about.blade.php ENDPATH**/ ?>