<?php $__env->startPush('css'); ?>
<style>
    .account.payment-confirm .account-wrapper{
        width: 800px;
    }
    @media only screen and (max-width: 991px){
    .account.payment-confirm .account-wrapper {
        width: 100%;
        padding: 15px
    }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start Payment-preview
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->

    <section class="checkout-section bg_img" data-background="<?php echo e(asset('public/frontend/')); ?>/images/checkout/checkout-bg-1.jpg">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="checkout-wrapper">
                        <div class="checkout-top-area">
                            <div class="profile-area">
                                <img src="<?php echo e(get_image($user->image,'user-profile','profile')); ?>" alt="client">
                            </div>
                            <div class="logo-area">
                                <img src="<?php echo e(get_fav($basic_settings)); ?>" alt="logo">
                            </div>
                            <span class="price-area"><?php echo e(get_amount($request_record->amount,$request_record->currency,4)); ?></span>
                        </div>
                        <div class="card-wrapper d-none" ></div>

                        <form class="checkout-form" method="POST" action="<?php echo e($submit_form_url); ?>" id="payment-form">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="trx_type">
                            <div class="account-info-wrapper">
                                <h5 class="title"><?php echo e(@$user->fullname); ?></h5>
                                <?php
                                    $address = (object)$user->address;
                                ?>
                                <span><?php echo e(@$address->address); ?></span>
                            </div>
                            <div class="switch-wrapper">
                                <h4 class="title"><?php echo e(__("Pay with")); ?></h4>
                            </div>
                            <div class="radio-wrapper">
                                <?php if(@$gateway_setting->wallet_status == true): ?>
                                <div class="radio-item">
                                    <div class="radio-item-wrapper">
                                        <input type="radio" name="checkout" checked id="wallet">
                                        <label for="wallet">
                                          <div class="icon"><i class="fas fa-wallet"></i></div>
                                          <div class="content">
                                            <h6 class="title"><?php echo e(__("Wallet Balance")); ?></h6>
                                            <span><?php echo e(__("Pay hassle-free using your available Wallet Balance.")); ?></span>
                                          </div>
                                        </label>
                                    </div>
                                    <?php
                                        $wallet = (object)$wallet;
                                    ?>
                                    <span class="amount-area"><?php echo e(get_amount($request_record->amount,$request_record->currency,4)); ?></span>
                                </div>
                                <?php endif; ?>
                                <?php if(@$gateway_setting->virtual_card_status == true): ?>
                                <div class="radio-item">
                                    <div class="radio-item-wrapper">
                                        <input type="radio" name="checkout" id="virtual_card">
                                        <label for="virtual_card">
                                          <div class="icon"><i class="fas fa-credit-card"></i></div>
                                          <div class="content">
                                            <h6 class="title"><?php echo e(__("Virtual Card")); ?></h6>
                                            <span><?php echo e(__("Pay hassle-free using your available Virtual Card Balance.")); ?></span>
                                          </div>
                                        </label>
                                    </div>
                                    <?php if(isset($user->payment_type)): ?>
                                        <?php
                                            $card_balance = (object)$user->virtual_card;
                                            $card_balance = $card_balance->amount??0;
                                        ?>
                                        <span class="amount-area"><?php echo e(get_amount($request_record->amount,$request_record->currency,3)); ?></span>
                                    <?php else: ?>

                                        <?php
                                            if(virtual_card_system('flutterwave')){
                                                $card = (object)$user->virtual_card;
                                                $card_balance = $card->amount??0;
                                            }elseif(virtual_card_system('sudo')){
                                                $card = (object)$user->virtual_card_sudo;
                                                $card_balance = $card->amount??0;
                                            }elseif(virtual_card_system('stripe')){
                                                $card = (object)$user->virtual_card_stripe;
                                                $card_balance = $card->amount??0;
                                            }elseif(virtual_card_system('strowallet')){
                                                $card = (object)$user->virtual_card_strowallet;
                                                $card_balance = $card->balance??0;
                                            }
                                           $exchange_rate = ($card->card_currency->rate/$currency->rate)??1;
                                           $payable_card_balane = $request_record->amount * $exchange_rate;

                                        ?>
                                        <span class="amount-area"><?php echo e(get_amount($payable_card_balane,$card->currency,4)); ?></span>
                                    <?php endif; ?>


                                </div>
                                <?php endif; ?>
                                <?php if(@$gateway_setting->master_visa_status == true): ?>
                                <div class="radio-item">
                                    <div class="radio-item-wrapper">
                                        <input type="radio" name="checkout" id="title3" value="title3">
                                        <label for="title3">
                                          <div class="icon"><i class="fab fa-cc-visa"></i></div>
                                          <div class="content">
                                            <h6 class="title"><?php echo e(__("Master / Visa Card")); ?></h6>
                                            <span><?php echo e(__("Enjoy the flexibility of paying with it.")); ?></span>
                                          </div>
                                        </label>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                            <div class="input-wrapper" id="title3-fields">
                                <div class="row mb-20-none">
                                    <div class="col-lg-6 form-group">
                                        <input type="text" class="form--control custom-input" placeholder="Cardholder Name" name="name" autocomplete="off" autofocus>
                                    </div>
                                    <div class="col-lg-6 form-group card-number">
                                        <input type="tel" class="form--control custom-input" placeholder="Card number" name="cardNumber" autocomplete="off" autofocus>
                                        <i class="las la-credit-card"></i>
                                    </div>
                                    <div class="col-lg-6 form-group">
                                        <input type="tel" id="expiryDateInput" class="form--control custom-input" placeholder="Expiry Date" name="cardExpiry" autocomplete="off" >
                                    </div>
                                    <div class="col-lg-6 form-group">
                                        <input type="password" class="form--control custom-input" placeholder="CVV"  name="cardCVC" autocomplete="off">
                                    </div>
                                </div>
                            </div>

                            <?php if(@$gateway_setting->wallet_status === false && @$gateway_setting->virtual_card_status === false && @$gateway_setting->master_visa_status === false): ?>
                            <div class="btn-area">
                                <button type="button" class="btn--base w-100"><i class="las la-angle-left ms-1"></i><?php echo e(__("All Payment Option Diabled")); ?></button>
                            </div>
                            <?php else: ?>
                            <div class="btn-area">
                                <button type="submit" class="btn--base w-100"><?php echo e(__("Continue to Review Order")); ?><i class="las la-angle-right ms-1"></i></button>
                            </div>
                            <?php endif; ?>
                            <a href="<?php echo e(url($request_record->data->cancel_url . "?token=".$token)); ?>" class="home-btn"><?php echo e(__("Cancel and return to Home")); ?></a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <?php
            $lang = selectedLang();
            $footer_slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::FOOTER_SECTION);
            $footer = App\Models\Admin\SiteSections::getData( $footer_slug)->first();
            $type =  Illuminate\Support\Str::slug(App\Constants\GlobalConst::USEFUL_LINKS);
            $policies = App\Models\Admin\SetupPage::orderBy('id')->where('type', $type)->where('status',1)->get();
        ?>
        <div class="bottom-area">
            <div class="bottom-wrapper">
                <p><?php echo e(__(@$footer->value->language->$lang->footer_text)); ?> <a class="fw-bold" href="<?php echo e(setRoute('index')); ?>"> <?php echo e($basic_settings->site_name); ?></a></p>
                <ul class="bottom-area-list">
                    <?php $__currentLoopData = $policies ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><a href="<?php echo e(setRoute('useful.link',$data->slug)); ?>" target="_blank"><?php echo e(@$data->title->language->$lang->title); ?></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        </div>
    </section>
    <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        End Payment-preview
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->

<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
<script src="<?php echo e(asset('public/frontend/')); ?>/js/card.js"></script>
<script>
    (function ($) {
    "use strict";
    var card = new Card({
        form: '#payment-form',
        container: '.card-wrapper',
        formSelectors: {
            numberInput: 'input[name="cardNumber"]',
            expiryInput: 'input[name="cardExpiry"]',
            cvcInput: 'input[name="cardCVC"]',
            nameInput: 'input[name="name"]'
        }
    });
    })(jQuery);
</script>
 <script>
    $(".radio-item").click(function() {
    var inputRadio = $(this).find("input[type=radio]");
    $(".radio-wrapper").find("input[type=radio]").attr("checked",false);
    inputRadio.attr("checked",true);
    var radioValue = inputRadio.val();
    $(".input-wrapper").hide();
    $(".input-wrapper").removeClass("active");
    // $(".input-wrapper").slideUp();
    var makeId = radioValue + "-fields";
    $("#"+makeId).show(200);
    $("#"+makeId).addClass("active");
    // $("#"+makeId).slideDown();
    });
    //get trx type
    $(document).ready(function(){
        $("input[name=trx_type]").val('<?php echo e(payment_gateway_const()::WALLET); ?>')
    });
   $("#wallet").click(function(){
        $("input[name=trx_type]").val('<?php echo e(payment_gateway_const()::WALLET); ?>')
    });
    $("#virtual_card").click(function(){
        $("input[name=trx_type]").val('<?php echo e(payment_gateway_const()::VIRTUAL); ?>')
    });
    $("#title3").click(function(){
        $("input[name=trx_type]").val('<?php echo e(payment_gateway_const()::MASTER); ?>')
    });


 </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('qrpay-gateway.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp-8.0.2\htdocs\qrpay\v4.5.0\multiple\resources\views/qrpay-gateway/pages/confirm.blade.php ENDPATH**/ ?>