<?php if(admin_permission_by_name("admin.users.kyc.reject")): ?>
    <?php if(isset($user)): ?>
        <?php if($user->kyc_verified != global_const()::REJECTED): ?>
            
            <div id="reject-modal" class="mfp-hide large">
                <div class="modal-data">
                    <div class="modal-header px-0">
                        <h5 class="modal-title"><?php echo e(__("Rejejct KYC ")); ?> <?php echo e("@" . $user->username); ?></h5>
                    </div>
                    <div class="modal-form-data">
                        <form class="modal-form" method="POST" action="<?php echo e(setRoute('admin.users.kyc.reject',$user->username)); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="target" value="<?php echo e($user->username); ?>">
                            <div class="row mb-10-none">
                                <div class="col-xl-12 col-lg-12 form-group">
                                        <?php echo $__env->make('admin.components.form.textarea',[
                                            'label'     => "Explain Rejection Reason*",
                                            'name'      => "reason",
                                            'value'     => old("reason"),
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                
                                <div class="col-xl-12 col-lg-12 form-group d-flex align-items-center justify-content-between mt-4">
                                    <button type="button" class="btn btn--danger modal-close"><?php echo e(__("Cancel")); ?></button>
                                    <button type="submit" class="btn btn--base"><?php echo e(__("Submit")); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php $__env->startPush("script"); ?>
            <script>
                $(".reject-btn").click(function(){
                    openModalBySelector($("#reject-modal"))
                });
            </script>
        <?php $__env->stopPush(); ?>
    <?php endif; ?>
<?php endif; ?><?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/admin/components/modals/kyc-reject.blade.php ENDPATH**/ ?>