<?php
    $lang = selectedLang();
    $security_slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::SECURITY_SECTION);
    $security = App\Models\Admin\SiteSections::getData( $security_slug)->first();
?>

<section class="security-section pt-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-12 text-center">
                <div class="section-header">
                    <span class="section-sub-titel"><i class="fas fa-qrcode"></i> <?php echo e(__(@$security->value->language->$lang->heading)); ?></span>
                    <h2 class="section-title"><?php echo e(__(@$security->value->language->$lang->sub_heading)); ?></h2>
                    <p><?php echo e(__(@$security->value->language->$lang->details)); ?></p>
                </div>
            </div>
        </div>
        <div class="row mb-30-none justify-content-center">

                <?php if(isset($security->value->items)): ?>
                    <?php $__currentLoopData = $security->value->items ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-4 col-md-6 mb-30">
                        <div class="security-item">
                            <span class="icon"><i class="<?php echo e(__( @$item->language->$lang->icon)); ?>"></i></span>
                            <div class="security-content">
                                <h4 class="title"><?php echo e(__( @$item->language->$lang->title)); ?></h4>
                                <p><?php echo e(__( @$item->language->$lang->sub_title)); ?></p>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

        </div>
    </div>
</section>
<?php /**PATH E:\xampp-8.0.2\htdocs\qrpay\v4.5.0\multiple\resources\views/frontend/partials/security-section.blade.php ENDPATH**/ ?>