

<?php $__env->startPush('css'); ?>
    <style>
        .fileholder {
            min-height: 200px !important;
        }

        .fileholder-files-view-wrp.accept-single-file .fileholder-single-file-view,.fileholder-files-view-wrp.fileholder-perview-single .fileholder-single-file-view{
            height: 156px !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title',['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ],
        [
            'name'  => __("Gateways"),
            'url'   => setRoute('admin.payment.gateway.view',[$gateway->slug,strtolower($gateway->type)]),
        ],
        [
            'name'  => $gateway->name,
            'url'   => setRoute('admin.payment.gateway.edit',[$gateway->slug,strtolower($gateway->type),$gateway->alias]),
        ]
    ], 'active' => __("Crypto Assets")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="custom-card mb-10">
        <div class="card-header">
            <h6 class="title fw-bold"><?php echo e(__("Crypto Wallets")); ?></h6>
            
                <div class="table-btn-area">
                    <?php echo $__env->make('admin.components.link.custom',[
                        'href'          => setRoute('admin.crypto.assets.generate.wallet', $gateway->alias),
                        'class'         => "btn--base",
                        'text'          => __("Generate Wallets"),
                        'permission'    => "admin.crypto.assets.generate.wallet",
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            
        </div>
        <div class="card-body">
            <?php echo e(__("Wallet not present in some currency/coin.")); ?> <?php echo e(__("Ex:")); ?> <?php $__currentLoopData = $wallet_not_available_coins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php echo e($coin); ?>&nbsp;
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            . <?php echo e(__("Click the generate wallets button to create dynamically wallets.")); ?>

        </div>
    </div>

    <?php $__currentLoopData = $gateway->supported_currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

        <div class="custom-card mb-10">
            <div class="card-header">
                <h6 class="title fw-bold"><?php echo e($currency); ?></h6>
                <div class="table-btn-area">
                    <?php echo $__env->make('admin.components.link.add-default',[
                        'href'          => "#wallet-store",
                        'class'         => "modal-btn wallet-add-btn",
                        'text'          => __("Add Wallet"),
                        'permission'    => "admin.crypto.assets.wallet.store",
                        'attribute'     => "data-coin=$currency data-gateway=$gateway->alias",
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php
                        $wallet_assets = $gateway->cryptoAssets->where('coin', $currency)->first();
                    ?>

                    <?php $__empty_1 = true; $__currentLoopData = $wallet_assets->credentials->credentials ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <div class="col-4 form-group switcher" data-target="<?php echo e($wallet_assets->id); ?>" data-credentials="<?php echo e($item->id); ?>">
                                        <?php echo $__env->make('admin.components.form.switcher',[
                                            'label'         =>__("Status"),
                                            'name'          => 'type',
                                            'value'         => old('type',$item->status),
                                            'options'       => [__("active") => 1,__("Deactive") => 0],
                                            'status'        => true,
                                            'permission'    => 'admin.crypto.assets.wallet.status.update'
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>

                                    <div>
                                        <a href="<?php echo e(setRoute('admin.crypto.assets.wallet.balance.update',[$wallet_assets->id,$item->id])); ?>" class="btn--base bg--primary py-1 px-2">
                                            <i class="las la-sync-alt"></i>
                                        </a>

                                        <?php echo $__env->make('admin.components.link.delete-default',[
                                            'href'          => 'javascript:void(0)',
                                            'class'         => 'wallet-delete-btn py-1 px-2',
                                            'permission'    => 'admin.crypto.assets.wallet.delete',
                                            'attribute'     => "data-id=$wallet_assets->id data-credential-id=$item->id",
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                        <?php echo $__env->make('admin.components.link.info-default',[
                                            'href'          => setRoute('admin.crypto.assets.wallet.transactions', [$wallet_assets->id, $item->id]),
                                            'class'         => 'py-1 px-2',
                                            'permission'    => 'admin.crypto.assets.wallet.transactions'
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <ul>
                                        <li class="border px-3 py-2 rounded mb-3">
                                            <span class="fw-bold">
                                                Mnemonic:
                                            </span>

                                            <?php echo e(@$item->mnemonic); ?>

                                        </li>

                                        <?php if(isset($item->xpub)): ?>
                                            <li class="border px-3 py-2 rounded mb-3">
                                                <span class="fw-bold">
                                                    Xpub:
                                                </span>

                                                <?php echo e($item->xpub); ?>

                                            </li>
                                        <?php endif; ?>

                                        <li class="border px-3 py-2 rounded mb-3">
                                            <span class="fw-bold">
                                                Private Key:
                                            </span>

                                            <?php echo e(@$item->private_key); ?>

                                        </li>

                                        <li class="border px-3 py-2 rounded mb-3">
                                            <span class="fw-bold">
                                                Public Address:
                                            </span>

                                            <?php echo e(@$item->address); ?>

                                        </li>

                                        <?php if(is_numeric($item->balance)): ?>
                                            <li class="border px-3 py-2 rounded mb-3">
                                                <span class="fw-bold">
                                                    Balance:
                                                </span>

                                                <?php echo e($item->balance); ?>

                                            </li>
                                        <?php endif; ?>

                                        <?php if(isset($item->balance->balance)): ?>
                                            <li class="border px-3 py-2 rounded mb-3">
                                                <span class="fw-bold">
                                                    Balance:
                                                </span>

                                                <?php echo e($item->balance->balance); ?>

                                            </li>
                                        <?php endif; ?>

                                        <?php if(isset($item->balance->incoming)): ?>
                                            <li class="border px-3 py-2 rounded mb-3">
                                                <span class="fw-bold">
                                                    Incoming Balance:
                                                </span>

                                                <?php echo e($item->balance->incoming); ?>

                                            </li>
                                        <?php endif; ?>

                                        <?php if(isset($item->balance->outgoing)): ?>
                                            <li class="border px-3 py-2 rounded mb-3">
                                                <span class="fw-bold">
                                                    Outgoing Balance:
                                                </span>

                                                <?php echo e($item->balance->outgoing); ?>

                                            </li>
                                        <?php endif; ?>

                                        <?php if(isset($item->balance->incomingPending)): ?>
                                            <li class="border px-3 py-2 rounded mb-3">
                                                <span class="fw-bold">
                                                    Incoming Pending Balance:
                                                </span>

                                                <?php echo e($item->balance->incomingPending); ?>

                                            </li>
                                        <?php endif; ?>

                                        <?php if(isset($item->balance->outgoingPending)): ?>
                                            <li class="border px-3 py-2 rounded mb-3">
                                                <span class="fw-bold">
                                                    Outgoing Pending Balance:
                                                </span>

                                                <?php echo e($item->balance->outgoingPending); ?>

                                            </li>
                                        <?php endif; ?>

                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="alert alert-warning col-12">
                            <?php echo e(__("This Coin is Under Maintenance Or Need to Generate Wallet. You Can Add Wallet Manually By Clicking Add Button.")); ?>

                        </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


    
    <?php if(admin_permission_by_name("admin.crypto.assets.wallet.store")): ?>
        <div id="wallet-store" class="mfp-hide large">
            <div class="modal-data">
                <div class="modal-header px-0">
                    <h5 class="modal-title"><?php echo e(__("Add New Wallet")); ?></h5>
                </div>
                <div class="modal-form-data">
                    <form class="modal-form" method="POST" action="<?php echo e(setRoute('admin.crypto.assets.wallet.store')); ?>">

                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="target" value="<?php echo e(old('target')); ?>">
                        <input type="hidden" name="gateway" value="<?php echo e(old('gateway')); ?>">

                        <div class="row mb-10-none">

                            <div class="col-12 form-group">
                                <?php echo $__env->make('admin.components.form.input',[
                                    'label'         => __("Mnemonic"),
                                    'label_after'   => '<span> (Optional)</span>',
                                    'name'          => 'mnemonic',
                                    'value'         => old('mnemonic')
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>

                            <div class="col-12 form-group">
                                <?php echo $__env->make('admin.components.form.input',[
                                    'label'         => __("Extended Public Key (Xpub)"),
                                    'label_after'   => '<span> (Optional)</span>',
                                    'name'          => 'xpub',
                                    'value'         => old('xpub')
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>

                            <div class="col-12 form-group">
                                <?php echo $__env->make('admin.components.form.input',[
                                    'label'         => __("Private Key"),
                                    'label_after'   => '<span> (Optional)</span>',
                                    'name'          => 'private_key',
                                    'value'         => old('private_key')
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>

                            <div class="col-12 form-group">
                                <?php echo $__env->make('admin.components.form.input',[
                                    'label'         => __("Public Address"),
                                    'label_after'   => '<span>*</span>',
                                    'name'          => 'public_address',
                                    'value'         => old('public_address')
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>

                            <div class="col-xl-12 col-lg-12 form-group d-flex align-items-center justify-content-between mt-4">
                                <button type="button" class="btn btn--danger modal-close"><?php echo e(__("Cancel")); ?></button>
                                <button type="submit" class="btn btn--base"><?php echo e(__("Add")); ?></button>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>
    

    
    <?php if(admin_permission_by_name("admin.crypto.assets.wallet.delete")): ?>
        <div id="wallet-delete" class="mfp-hide large">
            <div class="modal-data">
                <div class="modal-header px-0">
                    <h5 class="modal-title"><?php echo e(__("Delete Wallet")); ?></h5>
                </div>
                <div class="modal-form-data">
                    <form class="modal-form" method="POST" action="<?php echo e(setRoute('admin.crypto.assets.wallet.delete')); ?>">

                        <?php echo csrf_field(); ?>
                        <?php echo method_field("DELETE"); ?>

                        <input type="hidden" name="target">
                        <input type="hidden" name="credentials_id">

                        <?php echo e(__("Are you sure to delete this wallet?")); ?>


                        <div class="row mb-10-none">
                            <div class="col-xl-12 col-lg-12 form-group d-flex align-items-center justify-content-between mt-4">
                                <button type="button" class="btn btn--base modal-close"><?php echo e(__("Cancel")); ?></button>
                                <button type="submit" class="btn btn--danger"><?php echo e(__("Delete")); ?></button>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>
    


    
    <?php if(admin_permission_by_name("admin.crypto.assets.wallet.status.update")): ?>
        <form class="modal-form d-none status-update-form" method="POST" action="<?php echo e(setRoute('admin.crypto.assets.wallet.status.update')); ?>">
            <?php echo csrf_field(); ?>
            <?php echo method_field("PUT"); ?>
            <input type="hidden" name="target">
            <input type="hidden" name="credentials_id">
        </form>
    <?php endif; ?>
    

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

    <script>
        $(document).ready(function(){
            openModalWhenError("wallet-store","#wallet-store");
        });

        $(".wallet-add-btn").click(function() {
            let coin = $(this).data('coin');
            let gateway = $(this).data('gateway');
            let storeModal = $("#wallet-store");
            storeModal.find("input[name=target]").val(coin);
            storeModal.find("input[name=gateway]").val(gateway);
        });

        $(".wallet-delete-btn").click(function() {
            let cryptoAssetId = $(this).data("id");
            let credentialsId = $(this).data("credential-id");

            let deleteModal = $("#wallet-delete");

            deleteModal.find('input[name=target]').val(cryptoAssetId);
            deleteModal.find('input[name=credentials_id]').val(credentialsId);

            openModalBySelector("#wallet-delete");
        });


        let timeOutTwo;
        $(".switcher .switch").bind("click", function() {

            let cryptoAssetId = $(this).parents(".switcher").data("target");
            let credentialsId = $(this).parents(".switcher").data("credentials");

            clearTimeout(timeOutTwo);
            timeOutTwo = setTimeout(() => {
                $(".status-update-form").find("input[name=target]").val(cryptoAssetId);
                $(".status-update-form").find("input[name=credentials_id]").val(credentialsId);
                $(".status-update-form").submit();
            }, 500);
        });

    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/admin/sections/crypto-assets/gateway/index.blade.php ENDPATH**/ ?>