<?php

namespace Database\Seeders\Admin;

use App\Models\Admin\GroupHasAgent;
use App\Models\Admin\GroupHasMerchant;
use App\Models\Admin\GroupHasTransactionCharge;
use App\Models\Admin\GroupHasUser;
use App\Models\Admin\SetupUserGroup;
use Illuminate\Database\Seeder;

class ChargeGroupSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        //make groups
        $data = [
            [
                'name'          => "User Default Group",
                'slug'          => 'user-default-group',
                'type'          => 0,
                'status'        => 1,
                'delete_able'   => 0,
                'last_edit_by'  => 1,
                'created_at'    => now(),
            ],
            [
                'name'          => "Agent Default Group",
                'slug'          => 'agent-default-group',
                'type'          => 1,
                'status'        => 1,
                'delete_able'   => 0,
                'last_edit_by'  => 1,
                'created_at'    => now(),
            ],
            [
                'name'          => "Merchant Default Group",
                'slug'          => 'merchant-default-group',
                'type'          => 2,
                'status'        => 1,
                'delete_able'   => 0,
                'last_edit_by'  => 1,
                'created_at'    => now(),
            ],
        ];

        SetupUserGroup::insert($data);
        //Assign Users To Group
        $data = [
                'group_id'      => 1,
                'user_id'       => 1,
        ];
        GroupHasUser::create($data);
        //Assign Agent To Group
        $data = [
                'group_id'      => 2,
                'agent_id'       => 1,
        ];
        GroupHasAgent::create($data);
        //Assign Merchant To Group
        $data = [
                'group_id'      => 3,
                'merchant_id'       => 1,
        ];
        GroupHasMerchant::create($data);


        //create default groups
        $group_has_transaction_charges = array(
            array('id' => '1','admin_id' => '1','group_id' => '1','slug' => 'transfer','title' => 'Transfer Money Charges','fixed_charge' => '2.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '1000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '0.00','agent_percent_commissions' => '0.00','agent_profit' => '0','status' => '1','created_at' => '2024-07-26 09:57:44','updated_at' => '2024-07-28 11:30:49'),
            array('id' => '2','admin_id' => '1','group_id' => '1','slug' => 'bill-pay','title' => 'Bill Pay Charges','fixed_charge' => '1.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '1000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '0.00','agent_percent_commissions' => '0.00','agent_profit' => '0','status' => '1','created_at' => '2024-07-26 09:57:44','updated_at' => NULL),
            array('id' => '3','admin_id' => '1','group_id' => '1','slug' => 'mobile-topup','title' => 'Mobile Topup Charges','fixed_charge' => '1.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '1000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '0.00','agent_percent_commissions' => '0.00','agent_profit' => '0','status' => '1','created_at' => '2024-07-26 09:57:44','updated_at' => NULL),
            array('id' => '4','admin_id' => '1','group_id' => '1','slug' => 'virtual-card','title' => 'Virtual Card Charges','fixed_charge' => '2.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '10000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '0.00','agent_percent_commissions' => '0.00','agent_profit' => '0','status' => '1','created_at' => '2024-07-26 09:57:44','updated_at' => '2024-07-28 11:54:15'),
            array('id' => '5','admin_id' => '1','group_id' => '1','slug' => 'remittance','title' => 'Remittance Charge','fixed_charge' => '2.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '1000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '0.00','agent_percent_commissions' => '0.00','agent_profit' => '0','status' => '1','created_at' => '2024-07-26 09:57:44','updated_at' => '2024-07-28 11:45:54'),
            array('id' => '6','admin_id' => '1','group_id' => '1','slug' => 'make-payment','title' => 'Make Payment Charge','fixed_charge' => '3.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '1000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '0.00','agent_percent_commissions' => '0.00','agent_profit' => '0','status' => '1','created_at' => '2024-07-26 09:57:44','updated_at' => '2024-07-28 11:47:41'),
            array('id' => '7','admin_id' => '1','group_id' => '1','slug' => 'request-money','title' => 'Request Money Charge','fixed_charge' => '1.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '1000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '0.00','agent_percent_commissions' => '0.00','agent_profit' => '0','status' => '1','created_at' => '2024-07-26 09:57:44','updated_at' => NULL),
            array('id' => '8','admin_id' => '1','group_id' => '1','slug' => 'pay-link','title' => 'Pay Link Charges','fixed_charge' => '1.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '1000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '0.00','agent_percent_commissions' => '0.00','agent_profit' => '0','status' => '1','created_at' => '2024-07-26 09:57:44','updated_at' => NULL),
            array('id' => '9','admin_id' => '1','group_id' => '1','slug' => 'money-out','title' => 'Money Out Charges','fixed_charge' => '1.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '1000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '1.00','agent_percent_commissions' => '1.00','agent_profit' => '1','status' => '1','created_at' => '2024-07-26 09:57:44','updated_at' => NULL),
            array('id' => '10','admin_id' => '1','group_id' => '1','slug' => 'reload-card','title' => 'Reload Card Charges','fixed_charge' => '1.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '1000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '0.00','agent_percent_commissions' => '0.00','agent_profit' => '0','status' => '1','created_at' => '2024-07-26 09:57:44','updated_at' => NULL),
            array('id' => '11','admin_id' => '1','group_id' => '1','slug' => 'gift-card','title' => 'Gift Card Charges','fixed_charge' => '1.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '1000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '0.00','agent_percent_commissions' => '0.00','agent_profit' => '0','status' => '1','created_at' => '2024-07-26 09:57:44','updated_at' => NULL),
            array('id' => '12','admin_id' => '1','group_id' => '1','slug' => 'money-exchange','title' => 'Money Exchange Charges','fixed_charge' => '2.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '1000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '0.00','agent_percent_commissions' => '0.00','agent_profit' => '0','status' => '1','created_at' => '2024-07-26 09:57:44','updated_at' => '2024-07-28 11:35:47'),
            array('id' => '13','admin_id' => '1','group_id' => '2','slug' => 'agent-transfer','title' => 'Transfer Money Charges','fixed_charge' => '1.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '1000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '1.00','agent_percent_commissions' => '1.00','agent_profit' => '1','status' => '1','created_at' => '2024-07-26 09:59:09','updated_at' => '2024-07-26 10:13:21'),
            array('id' => '14','admin_id' => '1','group_id' => '2','slug' => 'agent-bill-pay','title' => 'Bill Pay Charges','fixed_charge' => '1.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '1000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '1.00','agent_percent_commissions' => '1.00','agent_profit' => '1','status' => '1','created_at' => '2024-07-26 09:59:09','updated_at' => NULL),
            array('id' => '15','admin_id' => '1','group_id' => '2','slug' => 'agent-mobile-topup','title' => 'Mobile Topup Charges','fixed_charge' => '1.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '1000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '1.00','agent_percent_commissions' => '1.00','agent_profit' => '1','status' => '1','created_at' => '2024-07-26 09:59:09','updated_at' => NULL),
            array('id' => '16','admin_id' => '1','group_id' => '2','slug' => 'agent-remittance','title' => 'Remittance Charge','fixed_charge' => '1.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '1000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '1.00','agent_percent_commissions' => '1.00','agent_profit' => '1','status' => '1','created_at' => '2024-07-26 09:59:09','updated_at' => NULL),
            array('id' => '17','admin_id' => '1','group_id' => '2','slug' => 'agent-money-in','title' => 'Money In Charges','fixed_charge' => '1.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '1000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '1.00','agent_percent_commissions' => '1.00','agent_profit' => '1','status' => '1','created_at' => '2024-07-26 09:59:09','updated_at' => NULL),
            array('id' => '18','admin_id' => '1','group_id' => '2','slug' => 'agent-money-exchange','title' => 'Money Exchange Charges','fixed_charge' => '1.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '1000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '1.00','agent_percent_commissions' => '1.00','agent_profit' => '1','status' => '1','created_at' => '2024-07-26 09:59:09','updated_at' => '2024-07-26 10:13:14'),
            array('id' => '19','admin_id' => '1','group_id' => '3','slug' => 'merchant-pay-link','title' => 'Pay Link Charges','fixed_charge' => '1.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '1000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '0.00','agent_percent_commissions' => '0.00','agent_profit' => '0','status' => '1','created_at' => '2024-07-26 11:17:46','updated_at' => '2024-07-26 12:31:49'),
            array('id' => '20','admin_id' => '1','group_id' => '3','slug' => 'merchant-money-exchange','title' => 'Money Exchange Charges','fixed_charge' => '1.00','percent_charge' => '1.00','min_limit' => '1.00','max_limit' => '1000.00','monthly_limit' => '0.00','daily_limit' => '0.00','agent_fixed_commissions' => '0.00','agent_percent_commissions' => '0.00','agent_profit' => '0','status' => '1','created_at' => '2024-07-26 11:17:46','updated_at' => NULL)
          );


        GroupHasTransactionCharge::insert($group_has_transaction_charges);

    }
}
