<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title',['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ]
    ], 'active' => __("PayLink Api")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="custom-card">
        <div class="card-header">
            <h6 class="title"><?php echo e(__("PayLink Api")); ?></h6>
        </div>
        <div class="card-body">

            <div class="row mb-30-none">
                <div class="col-xxl-4 col-xl-6 col-md-6 mb-20">
                    <div class="gateway-item">
                        <div class="gateway-item-wrapper">
                            <div class="content">
                                <h4 class="title"><?php echo e(__("Wallet System")); ?></h4>
                                <span><i class="las la-exclamation-circle"></i><?php echo e(__("enable Or Disable This Features")); ?></span>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" name="wallet_status" type="checkbox" id="walletStatusCheckbox" <?php echo e(@$api->wallet_status == 1 ?'checked' :''); ?> >
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-4 col-xl-6 col-md-6 mb-20">
                    <div class="gateway-item">
                        <div class="gateway-item-wrapper">
                            <div class="content">
                                <h4 class="title"><?php echo e(__("Payment Gateway")); ?></h4>
                                <span><i class="las la-exclamation-circle"></i><?php echo e(__("enable Or Disable This Features")); ?></span>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="paymentGatewaySystem" <?php echo e(@$api->payment_gateway_status == 1 ?'checked' :''); ?>>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-4 col-xl-6 col-md-6 mb-20">
                    <div class="gateway-item">
                        <div class="gateway-item-wrapper">
                            <div class="content">
                                <h4 class="title"><?php echo e(__("Master / Visa Card")); ?> <small class="text--base">(<?php echo e(__("Stripe")); ?>)</small></h4>
                                <span><i class="las la-exclamation-circle"></i><?php echo e(__("enable Or Disable This Features")); ?></span>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input master-visa-switch" type="checkbox" id="masterVisaStatusCheckBox" <?php echo e(@$api->card_status == 1 ?'checked' :''); ?>>
                            </div>
                        </div>
                        <form class="master-visa-api-form mt-20 <?php echo e(@$api->card_status == 1 ?'active' :''); ?>" id="master" action="<?php echo e(setRoute('admin.gateway.api.update.card.credentials')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="api-input-wrapper mb-20-none">
                                <div class="form-group">
                                    <label><?php echo e(__("Public Key")); ?> <span class="text--base">*</span></label>
                                    <input type="text" name="public_key" placeholder="<?php echo e(__("Public Key")); ?>" class="form--control" value="<?php echo e(@$api->public_key); ?>" required value="<?php echo e(old('public_key')); ?>">
                                </div>
                                <div class="form-group">
                                    <label><?php echo e(__("secret Key")); ?> <span class="text--base">*</span></label>
                                    <input type="text" name="secret_key" placeholder="<?php echo e(__("secret Key")); ?>" class="form--control" value="<?php echo e(@$api->secret_key); ?>" required value="<?php echo e(old('secret_key')); ?>">
                                </div>
                                <div class="form-group">
                                    <button type="submit" class="btn--base w-100 btn-loading"><?php echo e(__("Save & Change")); ?> <i class="fas fa-check-circle ms-1"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
<script>
    var app_mode = "<?php echo e(env('APP_MODE')); ?>"
    $(document).ready(function() {
        //wallet system
        $('#walletStatusCheckbox').on('change', function() {
            var status = this.checked ? 1 : 0;
            if(app_mode == "demo"){
                throwMessage('error',["Can't change anything for demo application."]);
                setTimeout(function wait(){
                    location.reload();
                },2000);
                return false;
            }

            $.ajax({
                url: '<?php echo e(setRoute("admin.gateway.api.update.wallet.status")); ?>',
                method: 'POST',
                data: {
                    status: status,
                    _token: '<?php echo e(csrf_token()); ?>'
                 },
                success: function(response) {
                    console.log(response);
                    var updated_status = response.status;
                    if(updated_status == 1){
                        throwMessage('success',["<?php echo e(__('EWallet System Enabled Successfully')); ?>"]);
                    }else{
                        throwMessage('success',["<?php echo e(__('Wallet System Disabled  Successfully')); ?>"]);
                    }
                },
                error: function(xhr, status, error) {

                    throwMessage('error',["Something is wrong!, Please try again later"]);
                }
            });
        });
        //virtual card
        $('#paymentGatewaySystem').on('change', function() {
            var status = this.checked ? 1 : 0;
            if(app_mode == "demo"){
                throwMessage('error',["Can't change anything for demo application."]);
                setTimeout(function wait(){
                    location.reload();
                },2000);
                return false;
            }
            $.ajax({
                url: '<?php echo e(setRoute("admin.gateway.api.update.payment.gateway.status")); ?>',
                method: 'POST',
                data: {
                    status: status,
                    _token: '<?php echo e(csrf_token()); ?>'
                 },
                success: function(response) {
                    var updated_status = response.status;
                    if(updated_status == 1){
                        throwMessage('success',["<?php echo e(__('EPayment Gateway System Enabled Successfully')); ?>"]);
                    }else{
                        throwMessage('success',["<?php echo e(__('Payment Gateway System Disabled Successfully')); ?>"]);
                    }
                },
                error: function(xhr, status, error) {
                    throwMessage('error',["Something is wrong!, Please try again later"]);
                }
            });
        });
        //Master/Visa card
        $('#masterVisaStatusCheckBox').on('change', function() {

            var status = this.checked ? 1 : 0;
            if(app_mode == "demo"){
                throwMessage('error',["Can't change anything for demo application."]);
                setTimeout(function wait(){
                    location.reload();
                },2000);
                return false;
            }
            if(status == 1){
                $('#master').addClass('active');
            }else{
                $('#master').removeClass('active');
            }
                $.ajax({
                url: '<?php echo e(setRoute("admin.gateway.api.update.card.status")); ?>',
                method: 'POST',
                data: {
                    status: status,
                    _token: '<?php echo e(csrf_token()); ?>'
                 },
                success: function(response) {
                    console.log(response);
                   var updated_status = response.status;
                   if(updated_status == 1){
                    throwMessage('success',["<?php echo e(__('Master/Visa Card System Enabled Successfully')); ?>"]);
                   }else{
                    throwMessage('success',["<?php echo e(__('DMaster/Visa Card System Disabled Successfully')); ?>"]);
                   }

                },
                error: function(xhr, status, error) {
                    throwMessage('error',["Something is wrong!, Please try again later"]);
                }
            });


        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp-8.0.2\htdocs\qrpay\v4.5.0\full_project\resources\views/admin/sections/gateway-api/index.blade.php ENDPATH**/ ?>