

<?php
    $lang = selectedLang();
    $contact_slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::CONTACT_SECTION);
    $contact = App\Models\Admin\SiteSections::getData( $contact_slug)->first();
?>

<?php $__env->startSection('content'); ?>

<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start Contact
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<section class="contact-section ptb-150">
    <div class="container">
        <div class="row justify-content-center mb-30-none">
            <div class="col-xl-5 col-lg-5 mb-30">
                <div class="contact-widget wow fadeInLeft" data-wow-duration="1s" data-wow-delay=".4s">
                    <div class="contact-form-header">
                        <h2 class="title"><?php echo e(__(@$contact->value->language->$lang->heading)); ?></h2>
                        <p><?php echo e(__(@$contact->value->language->$lang->sub_heading)); ?></p>
                    </div>
                    <ul class="contact-item-list">
                        <li>
                            <a href="#0">
                                <div class="contact-item-icon">
                                    <i class="las la-map-marked-alt"></i>
                                </div>
                                <div class="contact-item-content">
                                    <h5 class="title"><?php echo e(__("Our Location")); ?></h5>
                                    <span class="sub-title"><?php echo e(__(@$contact->value->language->$lang->location)); ?></span>
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="#0">
                                <div class="contact-item-icon tow">
                                    <i class="las la-phone-volume"></i>
                                </div>
                                <div class="contact-item-content">
                                    <h5 class="title"><?php echo e(__("Call Us At")); ?>: +<?php echo e(__(@$contact->value->language->$lang->mobile)); ?></h5>
                                    <span class="sub-title"><?php echo e(__(@$contact->value->language->$lang->office_hours)); ?></span>
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="#0">
                                <div class="contact-item-icon three">
                                    <i class="las la-envelope"></i>
                                </div>
                                <div class="contact-item-content">
                                    <h5 class="title"><?php echo e(__("Email Us Directly")); ?></h5>
                                    <span class="sub-title"><?php echo e(__(@$contact->value->language->$lang->email)); ?></span>
                                </div>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="col-xl-7 col-lg-7 mb-30">
                <div class="contact-form-inner wow fadeInRight" data-wow-duration="1s" data-wow-delay=".4s">
                    <div class="contact-form-area">
                        <form class="contact-form" action="<?php echo e(setRoute('contact.store')); ?>"  method="POST" id="contact-form">
                            <?php echo csrf_field(); ?>
                            <div class="row justify-content-center mb-10-none">
                                <div class="col-xl-6 col-lg-6 col-md-6 form-group">
                                    <label><?php echo e(__("name")); ?><span>*</span></label>
                                    <input type="text" name="name" class="form--control" placeholder="<?php echo e(__("Enter Name")); ?>" required>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-6 form-group">
                                    <label><?php echo e(__("Email")); ?><span>*</span></label>
                                    <input type="email" name="email" class="form--control" placeholder="<?php echo e(__("enter Email Address")); ?>" required>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-6 form-group">
                                    <label><?php echo e(__("Phone")); ?><span>*</span></label>
                                    <input type="text" name="mobile" class="form--control number-input" placeholder="<?php echo e(__("enter Phone")); ?>" required>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-6 form-group">
                                    <label><?php echo e(__("Subject")); ?><span>*</span></label>
                                    <input type="text" name="subject" class="form--control" placeholder="<?php echo e(__("Enter Subject")); ?>" required>
                                </div>
                                <div class="col-xl-12 col-lg-12 form-group">
                                    <label><?php echo e(__("Message")); ?><span>*</span></label>
                                    <textarea class="form--control" name="message" placeholder="<?php echo e(__("Write Here..")); ?>." required></textarea>
                                </div>

                                <div class="col-lg-12 form-group">
                                    <button type="submit" class="btn--base mt-10 contact-btn"><?php echo e(__("Send Message")); ?> <i class="las la-angle-right"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End Contact
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<?php $__env->stopSection(); ?>


<?php $__env->startPush("script"); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/frontend/contact.blade.php ENDPATH**/ ?>