<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title',['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ]
    ], 'active' => __("Money Out")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="table-area">
    <div class="table-wrapper">
        <div class="table-header">
            <h5 class="title"><?php echo e($page_title); ?></h5>
            <?php if(count($transactions) > 0): ?>
            <div class="table-btn-area">
                <a href="<?php echo e(setRoute('admin.agent.money.out.export.data')); ?>" class="btn--base"><i class="fas fa-download me-1"></i><?php echo e(__("Export Data")); ?></a>
            </div>
        <?php endif; ?>
        </div>
        <div class="table-responsive">
            <table class="custom-table">
                <thead>
                    <tr>
                        <th><?php echo e(__("TRX ID")); ?></th>
                        <th><?php echo e(__("Sender Type")); ?></th>
                        <th><?php echo e(__("sender")); ?></th>
                        <th><?php echo e(__("Receiver Type")); ?></th>
                        <th><?php echo e(__("Receiver")); ?></th>
                        <th><?php echo e(__("Sender Amount")); ?></th>
                        <th><?php echo e(__("Receiver Amount")); ?></th>
                        <th><?php echo e(__("charge")); ?></th>
                        <th><?php echo e(__("Payable")); ?></th>
                        <th><?php echo e(__(("Status"))); ?></th>
                        <th><?php echo e(__("Time")); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $transactions ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($item->trx_id); ?></td>
                            <td>
                                <?php echo e(__("USER")); ?>

                            </td>
                            <td>
                                <a href="<?php echo e(setRoute('admin.users.details',$item->creator->username)); ?>"><?php echo e($item->creator->email); ?></a>
                            </td>
                            <td>
                                <?php echo e(__("AGENT")); ?>

                            </td>
                            <td>
                                <a href="<?php echo e(setRoute('admin.agents.details',$item->details->receiver_username)); ?>"><?php echo e($item->details->receiver_email); ?></a>
                            </td>
                            <td><?php echo e(get_amount($item->details->charges->sender_amount,$item->details->charges->sender_currency,2)); ?></td>
                            <td><?php echo e(get_amount($item->details->charges->receiver_amount,$item->details->charges->receiver_currency,2)); ?></td>
                            <td><?php echo e(get_amount($item->details->charges->total_charge,$item->details->charges->sender_currency,2)); ?></td>
                            <td><?php echo e(get_amount($item->details->charges->payable,$item->details->charges->sender_currency,2)); ?></td>
                            <td>
                                <span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?></span>
                            </td>
                            <td><?php echo e($item->created_at->format('d-m-y h:i:s A')); ?></td>

                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                         <?php echo $__env->make('admin.components.alerts.empty',['colspan' => 11], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php echo e(get_paginate($transactions)); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/admin/sections/agent-money-out/index.blade.php ENDPATH**/ ?>