<?php if(isset($transactions)): ?>
    <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="dashboard-list-item-wrapper">
            <div class="dashboard-list-item sent">
                <div class="dashboard-list-left">
                    <div class="dashboard-list-user-wrapper">
                        <div class="dashboard-list-user-icon">
                            <?php if($item->attribute == payment_gateway_const()::SEND): ?>
                            <i class="las la-arrow-up"></i>
                            <?php else: ?>
                            <i class="las la-arrow-down"></i>
                            <?php endif; ?>
                        </div>
                        <div class="dashboard-list-user-content">
                            <?php if($item->type == payment_gateway_const()::TYPEADDMONEY): ?>
                                <h4 class="title"><?php echo e(__("Add Balance via")); ?> <span class="text--warning"><?php echo e(@$item->currency->name); ?></span></h4>
                            <?php elseif($item->type == payment_gateway_const()::TYPEMONEYOUT): ?>
                                <h4 class="title"><?php echo e(__("Withdraw Money")); ?> <span class="text--warning"><?php echo e(@$item->currency->name); ?></span></h4>
                            <?php elseif($item->type == payment_gateway_const()::BILLPAY): ?>
                                <h4 class="title"><?php echo e(__("Bill Pay")); ?> <span class="text--warning">(<?php echo e(@$item->details->bill_type_name); ?>)</span></h4>
                            <?php elseif($item->type == payment_gateway_const()::MOBILETOPUP): ?>
                                <h4 class="title"><?php echo e(__("Mobile Topup")); ?> <span class="text--warning">(<?php echo e(@$item->details->topup_type_name); ?>)</span></h4>
                            <?php elseif($item->type == payment_gateway_const()::TYPEADDSUBTRACTBALANCE): ?>
                            <h4 class="title"><?php echo e(__("Balance Update From Admin")); ?><?php echo e(__(" (".$item->creator_wallet->currency->code.")")); ?> </h4>
                            <?php elseif($item->type == payment_gateway_const()::TYPETRANSFERMONEY): ?>

                                <?php if($item->attribute == payment_gateway_const()::SEND): ?>
                                    <h4 class="title"><?php echo e(__("Send Money to")); ?> (<?php echo e($item->details->receiver->email??$item->details->receiver_email); ?>) </h4>
                                <?php elseif($item->attribute == payment_gateway_const()::RECEIVED): ?>
                                    <h4 class="title"><?php echo e(__("Received Money from")); ?> (<?php echo e($item->details->sender->email??$item->details->sender_email); ?>) </h4>
                                <?php endif; ?>

                            <?php elseif($item->type == payment_gateway_const()::AGENTMONEYOUT): ?>
                                    <h4 class="title"><?php echo e(__("Received Money from")); ?> <?php echo e(__(" @" .@$item->details->sender_username." (".@$item->details->sender_email.")")); ?> </h4>
                            <?php elseif($item->type == payment_gateway_const()::SENDREMITTANCE): ?>

                                <?php if($item->attribute == payment_gateway_const()::SEND): ?>
                                    <h4 class="title"><?php echo e(__("Send Remittance to")); ?> <?php echo e(__(" @" . $item->details->receiver_recipient->email)); ?> </h4>
                                <?php elseif($item->attribute == payment_gateway_const()::RECEIVED): ?>
                                    <h4 class="title"><?php echo e(__("Received Remittance from")); ?> <?php echo e(__(" @" .@$item->details->sender->fullname." (".@$item->details->sender->full_mobile.")")); ?> </h4>
                                <?php endif; ?>

                            <?php elseif($item->type == payment_gateway_const()::MONEYIN): ?>

                                    <?php if($item->attribute == payment_gateway_const()::SEND): ?>
                                        <h4 class="title"><?php echo e(__("Money In To")); ?> <?php echo e(__(" @" . @$item->details->receiver_username." (".@$item->details->receiver_email.")")); ?> </h4>

                                <?php endif; ?>
                            <?php elseif($item->type == payment_gateway_const()::TYPEMONEYEXCHANGE): ?>
                                <h4 class="title"><?php echo e(__("Exchange Money")); ?> <span class="text--warning"><?php echo e($item->details->charges->from_wallet_country); ?> <?php echo e(__("To")); ?> <?php echo e($item->details->charges->to_wallet_country); ?></span></h4>
                            <?php endif; ?>
                            <span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?> </span>
                        </div>
                    </div>
                </div>
                <div class="dashboard-list-right">
                    <?php if($item->type == payment_gateway_const()::TYPEADDMONEY): ?>
                        <h4 class="main-money text--warning"><?php echo e(get_amount($item->request_amount,$item->creator_wallet->currency->code)); ?></h4>
                        <h6 class="exchange-money fw-bold"><?php echo e(get_amount($item->payable,$item->currency->currency_code??get_default_currency_code(),4)); ?></h6>
                    <?php elseif($item->type == payment_gateway_const()::TYPEMONEYOUT): ?>
                        <h6 class="exchange-money text--warning fw-bold"><?php echo e(get_amount($item->request_amount,withdrawCurrency($item)['wallet_currency'])); ?></h6>
                        <h4 class="main-money "><?php echo e(get_amount($item->payable,withdrawCurrency($item)['gateway_currency'])); ?></h4>
                    <?php elseif($item->type == payment_gateway_const()::BILLPAY): ?>
                        <h4 class="main-money text--warning"><?php echo e(get_amount($item->request_amount,billPayCurrency($item)['wallet_currency'])); ?></h4>
                        <h6 class="exchange-money fw-bold"><?php echo e(get_amount($item->payable,billPayCurrency($item)['wallet_currency'])); ?></h6>
                    <?php elseif($item->type == payment_gateway_const()::MOBILETOPUP): ?>
                        <h4 class="main-money text--warning"><?php echo e(get_amount($item->request_amount,topUpCurrency($item)['wallet_currency'])); ?></h4>
                        <h6 class="exchange-money fw-bold"><?php echo e(get_amount($item->payable,topUpCurrency($item)['wallet_currency'])); ?></h6>
                    <?php elseif($item->type == payment_gateway_const()::TYPEADDSUBTRACTBALANCE): ?>
                        <h4 class="main-money text--base"><?php echo e(get_transaction_numeric_attribute($item->attribute)); ?><?php echo e(get_amount($item->request_amount,$item->creator_wallet->currency->code)); ?></h4>
                        <h6 class="exchange-money"><?php echo e(get_amount($item->available_balance,$item->creator_wallet->currency->code)); ?></h6>
                    <?php elseif($item->type == payment_gateway_const()::TYPETRANSFERMONEY): ?>
                        <?php if($item->attribute == payment_gateway_const()::SEND): ?>
                        <h6 class="exchange-money text--warning "><?php echo e(get_amount($item->details->charges->sender_amount??$item->request_amount,$item->details->charges->sender_currency??get_default_currency_code())); ?></h6>
                        <h4 class="main-money fw-bold"><?php echo e(get_amount($item->details->charges->payable??$item->payable,$item->details->charges->sender_currency??$item->payable)); ?></h4>
                        <?php elseif($item->attribute == payment_gateway_const()::RECEIVED): ?>
                        <h6 class="exchange-money fw-bold"><?php echo e(get_amount($item->details->charges->receiver_amount??$item->request_amount,$item->details->charges->receiver_currency??get_default_currency_code())); ?></h6>
                        <?php endif; ?>
                    <?php elseif($item->type == payment_gateway_const()::AGENTMONEYOUT): ?>
                        <?php if($item->attribute == payment_gateway_const()::RECEIVED): ?>
                        <h6 class="exchange-money fw-bold"><?php echo e(get_amount($item->details->charges->receiver_amount,$item->details->charges->receiver_currency)); ?></h6>
                        <?php endif; ?>
                    <?php elseif($item->type == payment_gateway_const()::SENDREMITTANCE): ?>
                        <?php if($item->attribute == payment_gateway_const()::SEND): ?>
                        <h6 class="exchange-money text--warning "><?php echo e(get_amount($item->request_amount,$item->details->charges->sender_cur_code??get_default_currency_code())); ?></h6>
                        <h4 class="main-money fw-bold"><?php echo e(get_amount($item->payable,$item->details->charges->sender_cur_code??get_default_currency_code())); ?></h4>
                        <?php elseif($item->attribute == payment_gateway_const()::RECEIVED): ?>
                        <h6 class="exchange-money fw-bold"><?php echo e(get_amount($item->payable,$item->details->charges->receiver_currency??get_default_currency_code())); ?></h6>
                        <?php endif; ?>
                    <?php elseif($item->type == payment_gateway_const()::MONEYIN): ?>
                        <h4 class="main-money text--warning"><?php echo e(get_amount($item->details->charges->sender_amount??$item->request_amount,$item->details->charges->sender_currency??get_default_currency_code())); ?></h4>
                        <h6 class="exchange-money fw-bold"><?php echo e(get_amount($item->details->charges->payable??$item->payable,$item->details->charges->sender_currency??get_default_currency_code())); ?></h6>
                    <?php elseif($item->type == payment_gateway_const()::TYPEMONEYEXCHANGE): ?>
                        <h4 class="main-money text--base"><?php echo e(get_amount($item->request_amount,$item->creator_wallet->currency->code)); ?></h4>
                        <h6 class="exchange-money"><?php echo e(get_amount($item->payable,$item->creator_wallet->currency->code)); ?></h6>
                    <?php endif; ?>
                </div>
            </div>
            <div class="preview-list-wrapper">
                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las la-text-width"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("type")); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="preview-list-right">
                        <span class="text--success"><?php echo e(@$item->type); ?></span>
                    </div>
                </div>
                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="lab la-tumblr"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("web_trx_id")); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="preview-list-right">
                        <span><?php echo e($item->trx_id); ?></span>
                    </div>
                </div>
                <?php if($item->type != payment_gateway_const()::TYPETRANSFERMONEY ): ?>
                <?php if($item->type != payment_gateway_const()::AGENTMONEYOUT ): ?>
                <?php if($item->type != payment_gateway_const()::SENDREMITTANCE ): ?>
                <div class="preview-list-item">

                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las la-exchange-alt"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("Exchange Rate")); ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="preview-list-right">
                        <?php if($item->type == payment_gateway_const()::TYPEADDMONEY): ?>
                            <span>1 <?php echo e($item->creator_wallet->currency->code); ?> = <?php echo e(get_amount($item->details->amount->exchange_rate??$item->currency->rate,$item->currency->currency_code??get_default_currency_code(),4)); ?></span>
                        <?php elseif($item->type == payment_gateway_const()::SENDREMITTANCE): ?>
                            <span>1 <?php echo e(get_default_currency_code()); ?> = <?php echo e(get_amount($item->details->to_country->rate,$item->details->to_country->code)); ?></span>
                        <?php elseif($item->type == payment_gateway_const()::TYPEMONEYOUT): ?>
                            <span>1 <?php echo e(withdrawCurrency($item)['wallet_currency']); ?> = <?php echo e(get_amount($item->details->charges->exchange_rate??$item->currency->rate??1,$item->currency->currency_code??get_default_currency_code())); ?></span>
                        <?php elseif($item->type == payment_gateway_const()::TYPEADDSUBTRACTBALANCE): ?>
                            <span>1 <?php echo e(get_default_currency_code()); ?> = <?php echo e(get_amount($item->creator_wallet->currency->rate,$item->creator_wallet->currency->code)); ?></span>
                        <?php elseif($item->type == payment_gateway_const()::BILLPAY): ?>
                        <span><?php echo e(get_amount(1,$item->details->charges->wallet_currency)." = ".get_amount($item->details->charges->exchange_rate,$item->details->charges->sender_currency,4)); ?></span>
                        <?php elseif($item->type == payment_gateway_const()::MOBILETOPUP): ?>
                            <?php if($item->details->topup_type == "MANUAL"): ?>
                                <span><?php echo e(get_amount(1,$item->details->charges->destination_currency)." = ".get_amount($item->details->charges->exchange_rate,$item->details->charges->sender_currency,4)); ?></span>
                            <?php elseif($item->details->topup_type == "AUTOMATIC"): ?>

                                <span><?php echo e(get_amount(1,$item->details->charges->sender_currency)." = ".get_amount($item->details->charges->exchange_rate,$item->details->charges->destination_currency,4)); ?></span>
                            <?php endif; ?>
                        <?php elseif($item->type == payment_gateway_const()::MONEYIN): ?>
                        <span><?php echo e(get_amount(1,$item->details->charges->sender_currency??get_default_currency_code())." = ".get_amount($item->details->charges->exchange_rate??get_default_currency_rate(),$item->details->charges->receiver_currency??get_default_currency_code())); ?></span>
                        <?php elseif($item->type == payment_gateway_const()::TYPEMONEYEXCHANGE): ?>
                        <span>1 <?php echo e($item->creator_wallet->currency->code); ?> = <?php echo e(get_amount($item->details->charges->exchange_rate,$item->details->charges->exchange_currency)); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
                <?php endif; ?>
                <?php endif; ?>


                <?php if($item->type == payment_gateway_const()::BILLPAY ): ?>
                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las la-balance-scale"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("bill Type")); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="preview-list-right">
                        <span class="text--base"><?php echo e(@$item->details->bill_type_name); ?></span>
                    </div>
                </div>
                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las las la-list-ol"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("Bill Month")); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="preview-list-right">
                        <span class="text--base"><?php echo e(@$item->details->bill_month); ?></span>
                    </div>
                </div>
                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las la-balance-scale"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("Bill Number")); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="preview-list-right">
                        <span class="text--base"><?php echo e(@$item->details->bill_number); ?></span>
                    </div>
                </div>
                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las la-balance-scale"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("Conversion Amount")); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="preview-list-right">
                        <span class="text--base"><?php echo e(get_amount($item->details->charges->conversion_amount,$item->details->charges->sender_currency)); ?></span>
                    </div>
                </div>
                <?php endif; ?>
                <?php if($item->type == payment_gateway_const()::MOBILETOPUP ): ?>
                    <?php if($item->details->topup_type == "MANUAL"): ?>
                        <div class="preview-list-item">
                            <div class="preview-list-left">
                                <div class="preview-list-user-wrapper">
                                    <div class="preview-list-user-icon">
                                        <i class="las la-balance-scale"></i>
                                    </div>
                                    <div class="preview-list-user-content">
                                        <span><?php echo e(__("Will Get")); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="preview-list-right">
                                <span class="text--base"><?php echo e(get_amount($item->details->charges->sender_amount,$item->details->charges->sender_currency)); ?></span>
                            </div>
                        </div>
                    <?php elseif($item->details->topup_type == "AUTOMATIC"): ?>
                        <div class="preview-list-item">
                            <div class="preview-list-left">
                                <div class="preview-list-user-wrapper">
                                    <div class="preview-list-user-icon">
                                        <i class="las la-balance-scale"></i>
                                    </div>
                                    <div class="preview-list-user-content">
                                        <span><?php echo e(__("Will Get")); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="preview-list-right">
                                <span class="text--base"><?php echo e(get_amount($item->details->charges->conversion_amount,$item->details->charges->destination_currency)); ?></span>
                            </div>
                    </div>
                    <?php endif; ?>

                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-balance-scale"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__("TopUp Type")); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span class="text--base"><?php echo e(@$item->details->topup_type_name); ?></span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="fas fa-mobile"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__("Mobile Number")); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span class="text--base"><?php echo e(@$item->details->mobile_number); ?></span>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if($item->type == payment_gateway_const()::TYPETRANSFERMONEY): ?>
                    <?php if($item->attribute == payment_gateway_const()::SEND): ?>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-exchange-alt"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__("Exchange Rate")); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e(get_amount(1,$item->details->charges->sender_currency??get_default_currency_code())." = ".get_amount($item->details->charges->exchange_rate??get_default_currency_rate(),$item->details->charges->receiver_currency??get_default_currency_code())); ?></span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-half"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__("fees And Charges")); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e(get_amount($item->charge->total_charge,$item->details->charges->sender_currency??get_default_currency_code())); ?></span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="lab la-get-pocket"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__("Recipient Received")); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e(get_amount($item->details->charges->receiver_amount??$item->details->recipient_amount,$item->details->charges->receiver_currency??get_default_currency_code())); ?></span>
                        </div>
                    </div>

                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-balance-scale"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__("Current Balance")); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span class="text--base"><?php echo e(get_amount($item->available_balance,$item->details->charges->sender_currency??get_default_currency_code())); ?></span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-receipt"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__("remark")); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span class="text--success"><?php echo e(@$item->remark); ?></span>
                        </div>
                    </div>
                <?php else: ?>
                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las la-balance-scale"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("Current Balance")); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="preview-list-right">
                        <span class="text--base"><?php echo e(get_amount($item->available_balance,$item->details->charges->receiver_currency)); ?></span>
                    </div>
                </div>
                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las la-receipt"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("remark")); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="preview-list-right">
                        <span class="text--success"><?php echo e(@$item->remark); ?></span>
                    </div>
                </div>
                <?php endif; ?>
                <?php else: ?>
                    <?php if($item->type != payment_gateway_const()::AGENTMONEYOUT ): ?>
                    <?php if($item->type != payment_gateway_const()::SENDREMITTANCE ): ?>
                    <?php if($item->type != payment_gateway_const()::MONEYIN ): ?>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-half"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__("fees And Charges")); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <?php if($item->type == payment_gateway_const()::TYPEADDMONEY): ?>
                                <span><?php echo e(get_amount($item->charge->total_charge??0,$item->currency->currency_code??get_default_currency_code(),4)); ?></span>
                            <?php elseif($item->type == payment_gateway_const()::TYPEMONEYOUT): ?>
                                <span><?php echo e(get_amount($item->charge->total_charge??0,withdrawCurrency($item)['wallet_currency'])); ?></span>
                            <?php elseif($item->type == payment_gateway_const()::SENDREMITTANCE): ?>
                                <span><?php echo e(get_amount($item->charge->total_charge,get_default_currency_code())); ?></span>
                            <?php elseif($item->type == payment_gateway_const()::BILLPAY): ?>
                                <span><?php echo e(get_amount($item->charge->total_charge,billPayCurrency($item)['wallet_currency'])); ?></span>
                            <?php elseif($item->type == payment_gateway_const()::MOBILETOPUP): ?>
                                <span><?php echo e(get_amount($item->charge->total_charge,topUpCurrency($item)['wallet_currency'])); ?></span>
                            <?php elseif($item->type == payment_gateway_const()::TYPEADDSUBTRACTBALANCE): ?>
                                <span><?php echo e(get_amount($item->charge->total_charge,$item->creator_wallet->currency->code)); ?></span>
                            <?php elseif($item->type == payment_gateway_const()::TYPEMONEYEXCHANGE): ?>
                                <span><?php echo e(get_amount($item->charge->total_charge,$item->creator_wallet->currency->code)); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php endif; ?>
                    <?php endif; ?>
                    <?php if($item->type != payment_gateway_const()::BILLPAY): ?>
                    <?php if($item->type != payment_gateway_const()::MOBILETOPUP): ?>
                    <?php if($item->type != payment_gateway_const()::SENDREMITTANCE): ?>
                    <?php if($item->type != payment_gateway_const()::MONEYIN): ?>
                    <?php if($item->type != payment_gateway_const()::AGENTMONEYOUT): ?>
                    <?php if($item->type != payment_gateway_const()::TYPEMONEYEXCHANGE): ?>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="lab la-get-pocket"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <?php if($item->type == payment_gateway_const()::TYPEADDMONEY): ?>
                                        <span><?php echo e(__("Current Balance")); ?></span>
                                    <?php elseif($item->type == payment_gateway_const()::TYPEMONEYOUT): ?>
                                        <span><?php echo e(__("Conversion Amount")); ?></span>
                                    <?php elseif($item->type == payment_gateway_const()::BILLPAY): ?>
                                        <span><?php echo e(__("Payable Amount")); ?></span>
                                    <?php elseif($item->type == payment_gateway_const()::MOBILETOPUP): ?>
                                        <span><?php echo e(__("Payable Amount")); ?></span>
                                    <?php elseif($item->type == payment_gateway_const()::TYPEADDSUBTRACTBALANCE): ?>
                                        <?php if($item->attribute ==  payment_gateway_const()::SEND): ?>
                                            <span><?php echo e(__("Total Deducted")); ?></span>
                                            <?php else: ?>
                                            <span><?php echo e(__("total Received")); ?></span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <?php if($item->type == payment_gateway_const()::TYPEADDMONEY): ?>
                                <span class="text-danger"><?php echo e(get_amount($item->available_balance,$item->creator_wallet->currency->code??get_default_currency_code())); ?></span>
                            <?php elseif($item->type == payment_gateway_const()::TYPEMONEYOUT): ?>
                            <span><?php echo e(get_amount($item->details->charges->payable??$item->request_amount,withdrawCurrency($item)['wallet_currency'])); ?></span>
                            <?php elseif($item->type == payment_gateway_const()::BILLPAY): ?>
                                <span class="fw-bold"><?php echo e(get_amount($item->payable,get_default_currency_code())); ?></span>
                            <?php elseif($item->type == payment_gateway_const()::MOBILETOPUP): ?>
                                <span class="fw-bold"><?php echo e(get_amount($item->payable,topUpCurrency($item)['wallet_currency'])); ?></span>
                            <?php elseif($item->type == payment_gateway_const()::TYPEADDSUBTRACTBALANCE): ?>
                                <span><?php echo e(get_amount($item->payable,$item->creator_wallet->currency->code)); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php endif; ?>
                    <?php endif; ?>
                    <?php endif; ?>
                    <?php endif; ?>
                    <?php endif; ?>

                    <?php if($item->type != payment_gateway_const()::TYPEADDMONEY): ?>
                    <?php if($item->type != payment_gateway_const()::SENDREMITTANCE): ?>
                    <?php if($item->type != payment_gateway_const()::MONEYIN): ?>
                    <?php if($item->type != payment_gateway_const()::AGENTMONEYOUT): ?>
                    <?php if($item->type != payment_gateway_const()::TYPEMONEYEXCHANGE): ?>

                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-receipt"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <?php if($item->type == payment_gateway_const()::TYPEADDMONEY): ?>
                                        <span><?php echo e(__("Total Amount")); ?></span>
                                    <?php elseif($item->type == payment_gateway_const()::TYPEMONEYOUT): ?>
                                        <span><?php echo e(__("Current Balance")); ?></span>
                                    <?php elseif($item->type == payment_gateway_const()::BILLPAY): ?>
                                        <span><?php echo e(__("Current Balance")); ?></span>
                                    <?php elseif($item->type == payment_gateway_const()::MOBILETOPUP): ?>
                                        <span><?php echo e(__("Current Balance")); ?></span>
                                    <?php elseif($item->type == payment_gateway_const()::TYPEADDSUBTRACTBALANCE): ?>
                                        <span><?php echo e(__("remark")); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="preview-list-right">
                            <?php if($item->type == payment_gateway_const()::TYPEADDMONEY): ?>
                                <span class="text--warning"><?php echo e(get_amount($item->payable,@$item->currency->currency_code??get_default_currency_code())); ?></span>
                            <?php elseif($item->type == payment_gateway_const()::TYPEMONEYOUT): ?>
                                <span class="text--danger"><?php echo e(get_amount($item->available_balance,withdrawCurrency($item)['wallet_currency']??get_default_currency_code())); ?></span>
                            <?php elseif($item->type == payment_gateway_const()::BILLPAY): ?>
                                <span class="text--danger"><?php echo e(get_amount($item->available_balance,billPayCurrency($item)['wallet_currency'])); ?></span>
                            <?php elseif($item->type == payment_gateway_const()::MOBILETOPUP): ?>
                                <span class="text--danger"><?php echo e(get_amount($item->available_balance,topUpCurrency($item)['wallet_currency'])); ?></span>
                            <?php elseif($item->type == payment_gateway_const()::TYPEADDSUBTRACTBALANCE): ?>
                                <span class="text--warning"><?php echo e($item->remark); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php endif; ?>
                    <?php endif; ?>
                    <?php endif; ?>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if($item->type == payment_gateway_const()::SENDREMITTANCE): ?>
                <?php if($item->attribute == payment_gateway_const()::SEND): ?>
                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las la-exchange-alt"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("Exchange Rate")); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="preview-list-right">
                        <span>1 <?php echo e($item->details->charges->sender_cur_code??get_default_currency_code()); ?> = <?php echo e(get_amount($item->details->charges->exchange_rate??$item->details->to_country->rate,$item->details->to_country->code)); ?></span>
                    </div>
                </div>
                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las la-battery-half"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("fees And Charges")); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="preview-list-right">
                        <span><?php echo e(get_amount($item->charge->total_charge,$item->details->charges->sender_cur_code??get_default_currency_code())); ?></span>
                    </div>
                </div>
                <?php endif; ?>
                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las la-flag"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("sending Country")); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="preview-list-right">
                        <span><?php echo e(@$item->details->form_country); ?></span>
                    </div>
                </div>
                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las la-flag"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("Receiving Country")); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="preview-list-right">
                        <span><?php echo e(@$item->details->to_country->country); ?></span>
                    </div>
                </div>
                <?php if($item->attribute == payment_gateway_const()::SEND): ?>
                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las la-user-tag"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("Sender Recipient Name")); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="preview-list-right">
                        <span><?php echo e(@$item->details->sender_recipient->firstname.' '.@$item->details->sender_recipient->lastname); ?></span>
                    </div>
                </div>
                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las la-user-tag"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("Receiver Recipient Name")); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="preview-list-right">
                        <span><?php echo e(@$item->details->receiver_recipient->firstname.' '.@$item->details->receiver_recipient->lastname); ?></span>
                    </div>
                </div>
                <?php endif; ?>
                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las la-cash-register"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("Transaction Type")); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="preview-list-right">
                            <?php if( @$item->details->remitance_type == "wallet-to-wallet-transfer"): ?>
                                    <span class="text-base"> <?php echo e(@$basic_settings->site_name); ?> <?php echo e(__("Wallet")); ?></span>
                                    <?php else: ?>
                                    <span class="text-base"> <?php echo e(ucwords(str_replace('-', ' ', @$item->details->remitance_type))); ?></span>

                            <?php endif; ?>
                    </div>
                </div>
                <?php if( @$item->details->remitance_type == "bank-transfer"): ?>

                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-piggy-bank"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__("bank Name")); ?></span>
                                </div>
                            </div>
                        </div>

                        <div class="preview-list-right">
                        <span class="text-base"> <?php echo e(ucwords(str_replace('-', ' ', @$item->details->receiver_recipient->alias))); ?></span>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if( @$item->details->remitance_type == "cash-pickup"): ?>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-piggy-bank"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__("Pickup Point")); ?></span>
                                </div>
                            </div>
                        </div>

                        <div class="preview-list-right">
                        <span class="text-base"> <?php echo e(ucwords(str_replace('-', ' ', @$item->details->receiver_recipient->alias))); ?></span>
                        </div>
                    </div>
                <?php endif; ?>
                 <?php if($item->attribute == payment_gateway_const()::SEND): ?>
                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las la-piggy-bank"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("Receipient Get")); ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="preview-list-right">
                    <span class="text-base fw-bold"> <?php echo e(get_amount($item->details->recipient_amount,$item->details->to_country->code)); ?></span>
                    </div>
                </div>
                <?php else: ?>
                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las la-smoking"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("Current Balance")); ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="preview-list-right">
                    <span class="text-base fw-bold"> <?php echo e(get_amount($item->available_balance,$item->details->charges->receiver_cur_code??get_default_currency_code())); ?></span>
                    </div>
                </div>
                <?php endif; ?>
                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las la-smoking"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("Current Balance")); ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="preview-list-right">
                    <span class="text-base fw-bold"> <?php echo e(get_amount($item->available_balance,$item->details->charges->sender_cur_code??get_default_currency_code())); ?></span>
                    </div>
                </div>
                <?php endif; ?>
                <?php if($item->type == payment_gateway_const()::MONEYIN): ?>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-half"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__("fees And Charges")); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e(get_amount($item->charge->total_charge,$item->creator_wallet->currency->code)); ?></span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="lab la-get-pocket"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__("Recipient Received")); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e(get_amount($item->details->charges->receiver_amount??$item->details->recipient_amount,$item->details->charges->receiver_currency??get_default_currency_code())); ?></span>
                        </div>
                    </div>

                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-balance-scale"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__("Current Balance")); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span class="text--base"><?php echo e(get_amount($item->available_balance,$item->details->charges->sender_currency??get_default_currency_code())); ?></span>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php if($item->type == payment_gateway_const()::AGENTMONEYOUT): ?>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="lab la-get-pocket"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__("Recipient Received")); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e(get_amount($item->details->charges->receiver_amount,$item->details->charges->receiver_currency)); ?></span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="lab la-get-pocket"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__("Profit Amount")); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e(get_amount($item->details->charges->agent_total_commission,$item->details->charges->receiver_currency)); ?></span>
                        </div>
                    </div>

                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-balance-scale"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__("Current Balance")); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span class="text--base"><?php echo e(get_amount($item->available_balance,$item->details->charges->receiver_currency)); ?></span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-receipt"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__("remark")); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span class="text--success"><?php echo e(@$item->remark); ?></span>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php if($item->type == payment_gateway_const()::TYPEMONEYEXCHANGE): ?>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-smoking"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__("Exchangeable Balance")); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span class="fw-bold"><?php echo e(get_amount($item->details->charges->exchange_amount,$item->details->charges->exchange_currency)); ?></span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-balance-scale"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__("Current Balance")); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span class="fw-bold"><?php echo e(get_amount($item->available_balance,$item->creator_wallet->currency->code)); ?></span>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las la-clock"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("Time & Date")); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="preview-list-right">
                        <span><?php echo e($item->created_at->format('d-m-y h:i:s A')); ?></span>
                    </div>
                </div>

                <?php if(@$item->type == payment_gateway_const()::TYPEADDMONEY): ?>
                <?php if($item->gateway_currency->gateway->isTatum($item->gateway_currency->gateway) && $item->status == payment_gateway_const()::STATUSWAITING): ?>
                <div class="col-12">
                    <form action="<?php echo e(setRoute('agent.add.money.payment.crypto.confirm', $item->trx_id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php
                            $input_fields = $item->details->payment_info->requirements ?? [];
                        ?>

                        <?php $__currentLoopData = $input_fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $input): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="p-3">
                                <h6 class="mb-2"><?php echo e($input->label); ?></h6>
                                <input type="text" class="form-control form--control ref-input text-light copiable" name="<?php echo e($input->name); ?>" placeholder="<?php echo e($input->placeholder ?? ""); ?>" required>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <div class="text-end">
                            <button type="submit" class="btn--base my-2"><?php echo e(__("Process")); ?></button>
                        </div>

                    </form>
                </div>
                <?php endif; ?>
            <?php endif; ?>

            <?php if( $item->status == 4 || $item->status == 6 &&  $item->reject_reason != null): ?>
                <div class="preview-list-item">
                    <div class="preview-list-left">
                        <div class="preview-list-user-wrapper">
                            <div class="preview-list-user-icon">
                                <i class="las la-smoking"></i>
                            </div>
                            <div class="preview-list-user-content">
                                <span><?php echo e(__("Rejection Reason")); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="preview-list-right">
                        <span class="text-danger"><?php echo e(__($item->reject_reason)); ?></span>
                    </div>
                </div>
                <?php endif; ?>



            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="alert alert-primary text-center">
            <?php echo e(__("No data found!")); ?>

        </div>
    <?php endif; ?>

    <?php echo e(get_paginate($transactions)); ?>



<?php endif; ?>
<?php /**PATH E:\xampp-8.0.2\htdocs\simple-pay\resources\views/agent/components/transaction-log.blade.php ENDPATH**/ ?>