<?php
    $lang = selectedLang();
    $auth_slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::AUTH_SECTION);
    $auth_text = App\Models\Admin\SiteSections::getData( $auth_slug)->first();
    $type =  Illuminate\Support\Str::slug(App\Constants\GlobalConst::USEFUL_LINKS);
    $policies = App\Models\Admin\SetupPage::orderBy('id')->where('type', $type)->where('slug',"terms-and-conditions")->where('status',1)->first();
?>

<?php $__env->startSection('content'); ?>
<section class="account">
    <div class="account-area">
        <div class="account-wrapper">
            <div class="account-logo text-center">
               <a class="site-logo" href="<?php echo e(setRoute('index')); ?>">
                <img src="<?php echo e(get_logo_agent($basic_settings)); ?>"  data-white_img="<?php echo e(get_logo_agent($basic_settings,'white')); ?>"
                data-dark_img="<?php echo e(get_logo_agent($basic_settings,'dark')); ?>"
                    alt="site-logo">
               </a>
            </div>
            <h5 class="title"><?php echo e(__("Register for an Account Today")); ?></h5>
            <p><?php echo e(__(@$auth_text->value->language->$lang->register_text)); ?></p>
            <form class="account-form" action="<?php echo e(route('agent.send.code')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="row ml-b-20">

                    <div class="col-xl-12 col-lg-12 form-group">
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text copytext"><span><?php echo e(__("Email")); ?></span></span>
                            </div>
                            <input type="email" name="email" class="form--control  " placeholder="Enter Email Address" required value="<?php echo e(old('email')); ?>">

                        </div>
                        <small class="text-danger exits"></small>
                    </div>

                    <?php if($basic_settings->agent_agree_policy): ?>
                    <div class="col-lg-12 form-group">
                        <div class="custom-check-group">
                            <input type="checkbox" id="agree" name="agree" required>
                            <label for="agree"><?php echo e(__("I have agreed with")); ?> <a href=" <?php echo e($policies != null? setRoute('useful.link',$policies->slug):"javascript:void(0)"); ?>"><?php echo e(__("Terms Of Use & Privacy Policy")); ?></a></label>
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="col-lg-12 form-group text-center">
                        <button type="submit"  class="btn--base w-100  btn-loading   "><?php echo e(__("Continue")); ?> </button>
                    </div>
                    <div class="col-lg-12 text-center">
                        <div class="account-item">
                            <label><?php echo e(__("already Have An Account")); ?> <a href="<?php echo e(setRoute('agent.login')); ?>" class="account-control-btn"><?php echo e(__("Login Now")); ?></a></label>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End acount
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->

<ul class="bg-bubbles">
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
</ul>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('agent.layouts.user_auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/agent/auth/register.blade.php ENDPATH**/ ?>