<table class="custom-table">
    <thead>
        <tr>
            <th><?php echo e(__("web_trx_id")); ?></th>
            <th><?php echo e(__("request Type")); ?></th>
            <th><?php echo e(__("request Amount")); ?></th>
            <th><?php echo e(__("Fees & Charges")); ?></th>
            <th><?php echo e(__("Payable")); ?></th>
            <th><?php echo e(__("Status")); ?></th>
            <th><?php echo e(__("Time")); ?></th>
            <th><?php echo e(__("Action")); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr data-id =<?php echo e($item->id); ?>>
                <td><?php echo e($item->trx_id); ?></td>
                <?php if($item->attribute == payment_gateway_const()::SEND): ?>
                <td><span class="text--info"><?php echo e(payment_gateway_const()::SEND); ?></span></td>
                <?php else: ?>
                <td><span class="text--info"><?php echo e(payment_gateway_const()::RECEIVED); ?></span></td>
                <?php endif; ?>
                <td><span> <?php echo e(get_amount($item->request_amount,$item->creator_wallet->currency->code)); ?></span></td>
                <?php if($item->attribute == payment_gateway_const()::SEND): ?>
                    <td><span class="text--info"><?php echo e(__("N/A")); ?></span></td>

                <?php else: ?>
                <td><?php echo e(get_amount($item->details->charges->total_charge,$item->creator_wallet->currency->code)); ?></td>
                <?php endif; ?>
                <?php if($item->attribute == payment_gateway_const()::SEND): ?>
                    <td><span class="text--info"><?php echo e(__("N/A")); ?></span></td>
                <?php else: ?>
                <td><?php echo e(get_transaction_numeric_attribute_request_money($item->attribute)); ?> <?php echo e(get_amount($item->payable,$item->creator_wallet->currency->code)); ?></td>
                <?php endif; ?>
                <td>
                    <span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?></span>
                </td>
                <td><?php echo e($item->created_at->format("Y-m-d H:i A")); ?></td>

                <?php if($item->attribute == payment_gateway_const()::RECEIVED): ?>
                    <td>
                        <button  class="btn btn--success approved-trx" <?php echo e($item->status ==  payment_gateway_const()::STATUSPENDING ? '' : 'disabled'); ?>><i class="las la-check"></i></button>
                        <button  class="btn btn--danger rejected-trx" <?php echo e($item->status ==  payment_gateway_const()::STATUSPENDING ? '' : 'disabled'); ?>><i class="las la-times"></i></button>
                    </td>
                <?php else: ?>
                    <td><span class="text--info"><?php echo e(__("N/A")); ?></span></td>
                <?php endif; ?>

            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <?php echo $__env->make('admin.components.alerts.empty2',['colspan' => 8], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
    </tbody>
</table>
<?php $__env->startPush('script'); ?>
    <script>
        $(".approved-trx").click(function(){
            var id = $(this).parents('tr').attr('data-id');
            var actionRoute =  "<?php echo e(setRoute('user.request.money.log.approve')); ?>";
            var target      = id;
            var btnText     = "Approve";
            var message     = `Are you sure to <strong>${btnText}</strong> this request?`;
            openAlertModal(actionRoute,target,message,btnText,"POST");
        });
    </script>
    <script>
        $(".rejected-trx").click(function(){
            var id = $(this).parents('tr').attr('data-id');
            var actionRoute =  "<?php echo e(setRoute('user.request.money.log.reject')); ?>";
            var target      = id;
            var btnText     = "Reject";
            var message     = `Are you sure to <strong>${btnText}</strong> this request?`;
            openAlertModal(actionRoute,target,message,btnText,"POST");
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH E:\xampp-8.0.2\htdocs\qrpay\v4.5.0\multiple\resources\views/user/sections/request-money/logs/table.blade.php ENDPATH**/ ?>