
<div class="sidebar">
    <div class="sidebar-inner">
        <div class="sidebar-menu-inner-wrapper">
            <div class="sidebar-logo">
                <a href="<?php echo e(setRoute('index')); ?>" class="sidebar-main-logo">
                    <img src="<?php echo e(get_logo($basic_settings)); ?>" data-white_img="<?php echo e(get_logo($basic_settings,"dark")); ?>"
                    data-dark_img="<?php echo e(get_logo($basic_settings)); ?>" alt="logo">
                </a>
                <button class="sidebar-menu-bar">
                    <i class="fas fa-exchange-alt"></i>
                </button>
            </div>
            <div class="sidebar-menu-wrapper">
                <ul class="sidebar-menu">
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('user.dashboard')); ?>">
                            <i class="menu-icon fas fa-th-large"></i>
                            <span class="menu-title"><?php echo e(__("Dashboard")); ?></span>
                        </a>
                    </li>
                    <?php if(module_access('receive-money',$module)->status): ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('user.receive.money.index')); ?>">
                            <i class="menu-icon fas fa-receipt"></i>
                            <span class="menu-title"><?php echo e(__("Receive Money")); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if(module_access('money-exchange',$module)->status): ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('user.money.exchange.index')); ?>">
                            <i class="menu-icon fas fa-exchange-alt"></i>
                            <span class="menu-title"><?php echo e(__("Money Exchange")); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if(module_access('send-money',$module)->status): ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('user.send.money.index')); ?>">
                            <i class="menu-icon fas fa-paper-plane"></i>
                            <span class="menu-title"><?php echo e(__("Send Money")); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if(module_access('pay-link',$module)->status): ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(route('user.payment-link.index')); ?>">
                            <i class="menu-icon fas fa-link"></i>
                            <span class="menu-title"><?php echo e(__('Payment Link')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if(module_access('request-money',$module)->status): ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('user.request.money.index')); ?>">
                            <i class="menu-icon fas fa-hand-holding-usd"></i>
                            <span class="menu-title"><?php echo e(__("request Money")); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if(module_access('remittance-money',$module)->status): ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('user.remittance.index')); ?>">
                            <i class="menu-icon fas fa-coins"></i>
                            <span class="menu-title"><?php echo e(__("Remittance")); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if(module_access('add-money',$module)->status): ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('user.add.money.index')); ?>">
                            <i class="menu-icon fas fa-plus-circle"></i>
                            <span class="menu-title"><?php echo e(__("Add Money")); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if(module_access('withdraw-money',$module)->status): ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('user.money.out.index')); ?>">
                            <i class="menu-icon fas fa-arrow-alt-circle-right"></i>
                            <span class="menu-title"><?php echo e(__("withdraw")); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if(module_access('make-payment',$module)->status): ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('user.make.payment.index')); ?>">
                            <i class="menu-icon fas fa-arrow-alt-circle-left"></i>
                            <span class="menu-title"><?php echo e(__("Make Payment")); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if(module_access('money-out',$module)->status): ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('user.agent.money.out.index')); ?>">
                            <i class="menu-icon fas fa-arrow-alt-circle-left"></i>
                            <span class="menu-title"><?php echo e(__("Money Out")); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if(module_access('virtual-card',$module)->status): ?>
                        <?php if(virtual_card_system('flutterwave')): ?>
                        <li class="sidebar-menu-item">
                            <a href="<?php echo e(setRoute('user.virtual.card.index')); ?>">
                                <i class="menu-icon fas fa-credit-card"></i>
                                <span class="menu-title"><?php echo e(__("Virtual Card")); ?></span>
                            </a>
                        </li>
                        <?php elseif(virtual_card_system('sudo')): ?>
                        <li class="sidebar-menu-item">
                            <a href="<?php echo e(setRoute('user.sudo.virtual.card.index')); ?>">
                                <i class="menu-icon fas fa-credit-card"></i>
                                <span class="menu-title"><?php echo e(__("Virtual Card")); ?></span>
                            </a>
                        </li>
                        <?php elseif(virtual_card_system('stripe')): ?>
                        <li class="sidebar-menu-item">
                            <a href="<?php echo e(setRoute('user.stripe.virtual.card.index')); ?>">
                                <i class="menu-icon fas fa-credit-card"></i>
                                <span class="menu-title"><?php echo e(__("Virtual Card")); ?></span>
                            </a>
                        </li>
                        <?php elseif(virtual_card_system('strowallet')): ?>
                        <li class="sidebar-menu-item">
                            <a href="<?php echo e(setRoute('user.strowallet.virtual.card.index')); ?>">
                                <i class="menu-icon fas fa-credit-card"></i>
                                <span class="menu-title"><?php echo e(__("Virtual Card")); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if(module_access('gift-cards',$module)->status): ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('user.gift.card.index')); ?>">
                            <i class="menu-icon fas fa-gift"></i>
                            <span class="menu-title"><?php echo e(__("Gift Card")); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if(module_access('bill-pay',$module)->status): ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('user.bill.pay.index')); ?>">
                            <i class="menu-icon fas fa-shopping-bag"></i>
                            <span class="menu-title"><?php echo e(__("Bill Pay")); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if(module_access('mobile-top-up',$module)->status): ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('user.mobile.topup.index')); ?>">
                            <i class="menu-icon fas fa-mobile"></i>
                            <span class="menu-title"><?php echo e(__("Mobile Topup")); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('user.transactions.index')); ?>">
                            <i class="menu-icon fas fa-arrows-alt-h"></i>
                            <span class="menu-title"><?php echo e(__("Transactions")); ?></span>
                        </a>
                    </li>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('user.receipient.index')); ?>">
                            <i class="menu-icon fas fa-user-check"></i>
                            <span class="menu-title"><?php echo e(__("Saved Recipients")); ?></span>
                        </a>
                    </li>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('user.security.google.2fa')); ?>">
                            <i class="menu-icon fas fa-qrcode"></i>
                            <span class="menu-title"><?php echo e(__("2FA Security")); ?></span>
                        </a>
                    </li>
                    <li class="sidebar-menu-item">
                        <a href="javascript:void(0)" class="logout-btn">
                            <i class="menu-icon fas fa-sign-out-alt"></i>
                            <span class="menu-title"><?php echo e(__("Logout")); ?></span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        <div class="sidebar-doc-box bg_img" data-background="<?php echo e(asset('public/frontend/')); ?>/images/element/support.jpg">
            <div class="sidebar-doc-icon">
                <i class="las la-question-circle"></i>
            </div>
            <div class="sidebar-doc-content">
                <h4 class="title"><?php echo e(__("help Center")); ?>?</h4>
                <p><?php echo e(__("How can we help you?")); ?></p>
                <div class="sidebar-doc-btn">
                    <a href="<?php echo e(setRoute('user.support.ticket.index')); ?>" class="btn--base w-100"><?php echo e(__("Get Support")); ?></a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->startPush('script'); ?>
    <script>
        $(".logout-btn").click(function(){
            var actionRoute =  "<?php echo e(setRoute('user.logout')); ?>";
            var target      = 1;
            var sureText = '<?php echo e(__("Are you sure to")); ?>';
            var message     = `${sureText} <strong><?php echo e(__("Logout")); ?></strong>?`;
            var logout = `<?php echo e(__("Logout")); ?>`;
            openAlertModal(actionRoute,target,message,logout,"POST");
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH E:\xampp 8.0.2\htdocs\simple-pay\resources\views/user/partials/side-nav.blade.php ENDPATH**/ ?>