<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('agent.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("agent.dashboard"),
        ]
    ], 'active' => __(@$page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="body-wrapper">
    <div class="dashboard-area mt-10">
        <div class="dashboard-header-wrapper">
            <h3 class="title"><?php echo e(__("Add Money")); ?></h3>
        </div>
    </div>
    <div class="row mb-30-none">
        <div class="col-lg-6 mb-30">
            <div class="dash-payment-item-wrapper">
                <div class="dash-payment-item active">
                    <div class="dash-payment-title-area">
                        <span class="dash-payment-badge">!</span>
                        <h5 class="title"><?php echo e(__($page_title)); ?></h5>
                    </div>
                    <div class="dash-payment-body">
                        <form class="card-form" action="<?php echo e(setRoute("agent.add.money.submit")); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-xl-12 col-lg-12 form-group text-center">
                                    <div class="exchange-area">
                                        <code class="d-block text-center"><span><?php echo e(__("Exchange Rate")); ?></span> <span class="rate-show">--</span></code>
                                    </div>
                                </div>
                                <div class="col-xl-6 col-lg-6 form-group">
                                    <label><?php echo e(__("Payment Gateway")); ?><span>*</span></label>
                                    <select class="form--control nice-select gateway-select" name="currency">
                                        <?php $__empty_1 = true; $__currentLoopData = $payment_gateways_currencies ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <option
                                                value="<?php echo e($item->alias); ?>"
                                                data-currency="<?php echo e($item->currency_code); ?>"
                                                data-min_amount="<?php echo e($item->min_limit); ?>"
                                                data-max_amount="<?php echo e($item->max_limit); ?>"
                                                data-percent_charge="<?php echo e($item->percent_charge); ?>"
                                                data-fixed_charge="<?php echo e($item->fixed_charge); ?>"
                                                data-rate="<?php echo e($item->rate); ?>"
                                                data-crypto="<?php echo e($item->gateway->crypto); ?>"
                                                >
                                                <?php echo e($item->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <option  disabled ><?php echo e(__('No Gateway Available')); ?></option>
                                        <?php endif; ?>
                                    </select>
                                </div>
                                <div class="col-xl-6 col-lg-6 form-group">

                                    <label><?php echo e(__("Amount")); ?><span>*</span></label>
                                    <div class="input-group">
                                        <input type="text" class="form--control" placeholder="<?php echo e(__('enter Amount')); ?>" required name="amount" value="<?php echo e(old("amount")); ?>">
                                        <select class="form--control nice-select wallet-currency" name="wallet_currency">
                                            <?php $__currentLoopData = $wallet_currencies ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($data->code); ?>" data-rate="<?php echo e($data->rate); ?>" data-currency-id="<?php echo e($data->id); ?>" data-sender-country-name="<?php echo e($data->name); ?>"><?php echo e($data->code); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <code class="d-block mt-10 text-end text--warning balance-show">--</code>
                                </div>
                                <div class="col-xl-12 col-lg-12 form-group">
                                    <div class="note-area">
                                        <code class="d-block limit-show">--</code>
                                        <code class="d-block fees-show">--</code>
                                    </div>
                                </div>
                                <div class="col-xl-12 col-lg-12">
                                    <button type="submit" class="btn--base w-100 btn-loading"><?php echo e(__("Add Money")); ?> <i class="fas fa-plus-circle ms-1"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-30">
            <div class="dash-payment-item-wrapper">
                <div class="dash-payment-item active">
                    <div class="dash-payment-title-area">
                        <span class="dash-payment-badge">!</span>
                        <h5 class="title"><?php echo e(__("Add Money Preview")); ?></h5>
                    </div>
                    <div class="dash-payment-body">
                        <div class="preview-list-wrapper">
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-receipt"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Entered Amount")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="request-amount">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-battery-half"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Total Fees & Charges")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="fees">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="lab la-get-pocket"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Will Get")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="will-get">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-money-check-alt"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span class="last"><?php echo e(__("Total Payable Amount")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="text--warning last pay-in-total">--</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="dashboard-list-area mt-20">
        <div class="dashboard-header-wrapper">
            <h4 class="title"><?php echo e(__("Add Money Logs")); ?></h4>
            <div class="dashboard-btn-wrapper">
                <div class="dashboard-btn mb-2">
                    <a href="<?php echo e(setRoute('agent.transactions.index','add-money')); ?>" class="btn--base"><?php echo e(__("View More")); ?></a>
                </div>
            </div>
        </div>
        <div class="dashboard-list-wrapper">
            <?php echo $__env->make('agent.components.transaction-log',compact("transactions"), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    var defualCurrency = "<?php echo e(get_default_currency_code()); ?>";
    var defualCurrencyRate = "<?php echo e(get_default_currency_rate()); ?>";
    var presion = 4;
    $('select[name=currency]').on('change',function(){
        isCrypto(),
        getExchangeRate();
        getLimit();
        getFees();
        activeItems();
    });
    $('select[name=wallet_currency]').on('change',function(){
        walletBalance();
        isCrypto(),
        getExchangeRate();
        getLimit();
        getFees();
        activeItems();
    });
    $(document).ready(function(){
        walletBalance();
        isCrypto(),
        getExchangeRate();
        getLimit();
        getFees();
    });
    $("input[name=amount]").keyup(function(){
            getFees();
            activeItems();
    });

    function acceptVar() {
        var selectedVal = $("select[name=currency] :selected");
        var currencyCode = $("select[name=currency] :selected").attr("data-currency");
        var currencyRate = $("select[name=currency] :selected").attr("data-rate");

        var cryptoType  = $("select[name=currency] :selected").attr("data-crypto");

        var currencyMinAmount = $("select[name=currency] :selected").attr("data-min_amount");
        var currencyMaxAmount = $("select[name=currency] :selected").attr("data-max_amount");
        var currencyFixedCharge = $("select[name=currency] :selected").attr("data-fixed_charge");
        var currencyPercentCharge = $("select[name=currency] :selected").attr("data-percent_charge");

        var wCurrencyVal            = $("select[name=wallet_currency] :selected");
        var wCurrencyCode            = $("select[name=wallet_currency] :selected").val();
        var wCurrencyRate            = $("select[name=wallet_currency] :selected").data('rate');

        return {
            currencyCode:currencyCode,
            currencyRate:currencyRate,
            cryptoType:cryptoType,
            currencyMinAmount:currencyMinAmount,
            currencyMaxAmount:currencyMaxAmount,
            currencyFixedCharge:currencyFixedCharge,
            currencyPercentCharge:currencyPercentCharge,
            selectedVal:selectedVal,

            wCurrencyVal:wCurrencyVal,
            wCurrencyCode:wCurrencyCode,
            wCurrencyRate:wCurrencyRate,

        };
    }
    function isCrypto(){
        var type = acceptVar().cryptoType;
        if(type == 1 ){
            presion = 8;
        }else{
            presion = 4;
        }
        return presion;
    }
    function getExchangeRate() {

        if(acceptVar().selectedVal.val() === "null"){
            return false;
        }
        var gCurrencyCode = acceptVar().currencyCode;
        var gCurrencyRate = acceptVar().currencyRate;
        var wCurrencyCode = acceptVar().wCurrencyCode;
        var wCurrencyRate = acceptVar().wCurrencyRate;

        var exchange_rate = parseFloat(gCurrencyRate) / parseFloat(wCurrencyRate);

        $('.rate-show').html("1 " + wCurrencyCode + " = " + parseFloat(exchange_rate).toFixed(presion) + " " + gCurrencyCode);
        return exchange_rate;
    }
    function getLimit() {
        var exchange_rate = getExchangeRate();
        var wCurrencyCode = acceptVar().wCurrencyCode;
        var wCurrencyRate = acceptVar().wCurrencyRate;
        var min_limit = acceptVar().currencyMinAmount;
        var max_limit =acceptVar().currencyMaxAmount;

        if($.isNumeric(min_limit) || $.isNumeric(max_limit)) {
            var min_limit_calc = parseFloat(min_limit/exchange_rate).toFixed(2);
            var max_limit_clac = parseFloat(max_limit/exchange_rate).toFixed(2);
            $('.limit-show').html("<?php echo e(__('limit')); ?> " + min_limit_calc + " " + wCurrencyCode + " - " + max_limit_clac + " " + wCurrencyCode);
            return {
                minLimit:min_limit_calc,
                maxLimit:max_limit_clac,
            };
        }else {
            $('.limit-show').html("--");
            return {
                minLimit:0,
                maxLimit:0,
            };
        }
    }

    function feesCalculation() {
        var exchange_rate   = getExchangeRate();
        var sender_amount   = $("input[name=amount]").val();
        sender_amount == "" ? (sender_amount = 0) : (sender_amount = sender_amount);

        var fixed_charge    = acceptVar().currencyFixedCharge;
        var percent_charge  = acceptVar().currencyPercentCharge;

        if ($.isNumeric(percent_charge) && $.isNumeric(fixed_charge) && $.isNumeric(sender_amount)) {
            // Process Calculation
            var fixed_charge_calc   = parseFloat(fixed_charge) * parseFloat(exchange_rate);
            var percent_charge_calc = (parseFloat(sender_amount) / 100) * parseFloat(percent_charge);
            var total_charge        = parseFloat(fixed_charge_calc) + parseFloat(percent_charge_calc);
            total_charge            = parseFloat(total_charge).toFixed(presion);
            // return total_charge;
            return {
                total: total_charge,
                fixed: fixed_charge_calc,
                percent: percent_charge,
            };
        } else {
            // return "--";
            return false;
        }
    }
    function getFees() {
        var gCurrencyCode = acceptVar().currencyCode;
        var percent = acceptVar().currencyPercentCharge;
        var charges = feesCalculation();
        if (charges == false) {
            return false;
        }
        $(".fees-show").html("<?php echo e(__('charge')); ?>: " + parseFloat(charges.fixed).toFixed(4) + " " + gCurrencyCode + " + " + parseFloat(charges.percent).toFixed(4) + "%");
    }
    function activeItems(){
            var selectedVal = acceptVar().selectedVal.val();
            if(selectedVal === undefined || selectedVal === '' || selectedVal === null){
                return false;
            }else{
                return getPreview();
            }
    }
    function getPreview() {
            var senderAmount = $("input[name=amount]").val();
            var wCurrencyCode = acceptVar().wCurrencyCode;
            var gCurrencyCode = acceptVar().currencyCode;
            var exchange_rate = getExchangeRate();

            senderAmount == "" ? senderAmount = 0 : senderAmount = senderAmount;

            // Sending Amount
            $('.request-amount').text(senderAmount + " " + wCurrencyCode);

            // Fees
            var charges = feesCalculation();
            $('.fees').text(charges.total + " " + gCurrencyCode);

            // will get amount
            var willGet = parseFloat(senderAmount).toFixed(presion);
            $('.will-get').text(willGet + " " + wCurrencyCode);

            // Pay In Total
            var totalPay = parseFloat(senderAmount) * parseFloat(exchange_rate);
            var pay_in_total = parseFloat(charges.total) + parseFloat(totalPay);
            $('.pay-in-total').text(parseFloat(pay_in_total).toFixed(presion) + " " + gCurrencyCode);

    }
    function walletBalance(){
        var senderCurrency = acceptVar().wCurrencyCode;
        var csrfToken = $('meta[name="csrf-token"]').attr('content');
        $.ajax({
            type: 'POST',
            url: "<?php echo e(route('agent.wallets.balance')); ?>",
            data: {
                target: senderCurrency,
                _token: csrfToken
            },
            success: function(response) {
                $('.balance-show').html("<?php echo e(__('Available Balance')); ?>: " + parseFloat(response.data).toFixed(presion) + " " + senderCurrency);
            }
        });
    }


</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('agent.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp-8.0.2\htdocs\qrpay\v4.5.0\multiple\resources\views/agent/sections/add-money/index.blade.php ENDPATH**/ ?>