<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('remitance_bank_deposits', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('admin_id');
            $table->string('name',100)->nullable();
            $table->string('alias',100)->index();
            $table->string('currency_name')->nullable();
            $table->string('code')->nullable();
            $table->string('currency_symbol')->nullable();
            $table->string('image',255)->nullable();
            $table->decimal('rate',28,8,true)->default(0);
            $table->decimal('fixed_charge',28,8,true)->default(0);
            $table->decimal('percent_charge',28,8,true)->default(0);
            $table->decimal('min_limit',28,8,true)->default(0);
            $table->decimal('max_limit',28,8,true)->default(0);
            $table->decimal('monthly_limit',28,8,true)->default(0);
            $table->decimal('daily_limit',28,8,true)->default(0);
            $table->decimal('agent_fixed_commissions',28,8,true)->default(0);
            $table->decimal('agent_percent_commissions',28,8,true)->default(0);
            $table->boolean('agent_profit')->default(false);
            $table->boolean('status')->default(true);
            $table->timestamps();
            $table->foreign('admin_id')->references('id')->on('admins')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('remitance_bank_deposits');
    }
};
