<?php
    $base_code =  getDialCode();
?>
<?php $__env->startPush('css'); ?>
    <style>
        .input-group.mobile-code .nice-select{
            border-radius: 5px 0 0 5px !important;
        }
        .input-group.mobile-code .nice-select .list{
            width: auto !important;
        }
        .input-group.mobile-code .nice-select .list::-webkit-scrollbar {
            height: 20px;
            width: 3px;
            background: #F1F1F1;
            border-radius: 10px;
        }

        .input-group.mobile-code .nice-select .list::-webkit-scrollbar-thumb {
            background: #999;
            border-radius: 10px;
        }

        .input-group.mobile-code .nice-select .list::-webkit-scrollbar-corner {
            background: #999;
            border-radius: 10px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('agent.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("agent.dashboard"),
        ]
    ], 'active' => __(@$page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="body-wrapper">
    <div class="dashboard-area mt-10">
        <div class="dashboard-header-wrapper">
            <h3 class="title"><?php echo e(__(@$page_title)); ?></h3>
        </div>
    </div>
    <div class="row mb-30-none">
        <div class="col-xl-6 mb-30">
            <div class="dash-payment-item-wrapper">
                <div class="dash-payment-item active">
                    <div class="dash-payment-title-area">
                        <span class="dash-payment-badge">!</span>
                        <h5 class="title"><?php echo e(__("Recharge")); ?></h5>
                    </div>
                    <div class="dash-payment-body">
                        <form class="card-form" action="<?php echo e(setRoute('agent.mobile.topup.manual.confirm')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-xl-12 col-lg-12 form-group text-center">
                                    <div class="exchange-area">
                                        <code class="d-block text-center"><span class="fees-show">--</span> <span class="limit-show">--</span></code>
                                    </div>
                                </div>
                                <div class="col-xl-6 col-lg-6  form-group">
                                    <label><?php echo e(__("Mobile Topup")); ?> <span class="text--base">*</span></label>
                                    <select class="form--control" name="topup_type">
                                        <?php $__empty_1 = true; $__currentLoopData = $topupType ??[]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                           <option value="<?php echo e($type->id); ?>" data-name="<?php echo e($type->name); ?>"><?php echo e($type->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                           <option disabled selected value="null"><?php echo e(__('No Items Available')); ?></option>
                                        <?php endif; ?>

                                    </select>
                                </div>

                                <div class="col-xl-6 col-lg-6  form-group">
                                    <label><?php echo e(__("Mobile Number")); ?><span>*</span></label>
                                    <div class="input-group mobile-code">
                                        <select class="form--control nice-select" name="mobile_code">
                                            <?php $__currentLoopData = get_all_countries() ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e(remove_speacial_char($code->mobile_code)); ?>" <?php echo e($code->name === auth()->user()->address->country ? 'selected' :''); ?>>+<?php echo e(remove_speacial_char($code->mobile_code)); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </select>
                                        <input type="text" class="form--control number-input" name="mobile_number" placeholder="<?php echo e(__("enter Mobile Number")); ?>" value="<?php echo e(old('mobile_number')); ?>">
                                    </div>

                                </div>
                                <div class="col-xxl-12 col-xl-12 col-lg-12  form-group">
                                    <label><?php echo e(__("Amount")); ?><span>*</span></label>
                                    <div class="input-group">
                                        <input type="text" class="form--control number-input" required placeholder="<?php echo e(__('enter Amount')); ?>" name="amount" value="<?php echo e(old("amount")); ?>">
                                        <select class="form--control nice-select currency" name="currency">
                                            <?php $__currentLoopData = $sender_wallets ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($data->code); ?>" data-rate="<?php echo e($data->rate); ?>" data-currency-id="<?php echo e($data->id); ?>" data-sender-country-name="<?php echo e($data->name); ?>"><?php echo e($data->code); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                </div>
                                <div class="col-xl-12 col-lg-12 form-group">
                                    <div class="note-area">
                                        <code class="d-block fw-bold balance-show"><?php echo e(__("Available Balance")); ?>: <?php echo e(authWalletBalance()); ?> <?php echo e(get_default_currency_code()); ?></code>
                                    </div>
                                </div>

                                <div class="col-xl-12 col-lg-12">
                                    <button type="submit" class="btn--base w-100 btn-loading mobileTopupBtn"><?php echo e(__("Recharge Now")); ?> <i class="fas fa-mobile ms-1"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-6 mb-30">
            <div class="dash-payment-item-wrapper">
                <div class="dash-payment-item active">
                    <div class="dash-payment-title-area">
                        <span class="dash-payment-badge">!</span>
                        <h5 class="title"><?php echo e(__("Preview")); ?></h5>
                    </div>
                    <div class="dash-payment-body">
                        <div class="preview-list-wrapper">
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-wallet"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Sending Wallet")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="fw-bold sending-wallet">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-plug"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("TopUp Type")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="topup-type">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-phone-volume"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Mobile Number")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="mobile-number">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-funnel-dollar"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Amount")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="request-amount">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-sync-alt"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Exchange Rate")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="exchange-rate">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-battery-half"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Total Charge")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="fees">--</span>
                                </div>
                            </div>

                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-money-check-alt"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Total Payable")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="text--base last payable-total">--</span>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    var defualCurrency = "<?php echo e(get_default_currency_code()); ?>";
    var defualCurrencyRate = "<?php echo e(get_default_currency_rate()); ?>";

    $(document).ready(function(){
        senderBalance();
        getLimit();
        getFees();
        getExchangeRate();
        activeItems();
    });
    $("input[name=amount]").keyup(function(){
        getFees();
        activeItems();
    });
    $("input[name=amount]").focusout(function(){
        enterLimit();
    });
    $("input[name=mobile_number]").keyup(function(){
        getFees();
        activeItems();
    });
    $("select[name=topup_type]").change(function(){
        getFees();
        activeItems();
    });
    $("select[name=mobile_code]").change(function(){
        activeItems();
    });
    $("select[name=currency]").change(function(){
        senderBalance();
        getLimit();
        getFees();
        getExchangeRate();
        activeItems();
    });
    function getLimit() {
    if(acceptVar().topUp.val() === "null"){
        return false;
    }
        var currencyCode = acceptVar().currencyCode;
        var currencyRate = acceptVar().currencyRate;

        var min_limit = acceptVar().currencyMinAmount;
        var max_limit =acceptVar().currencyMaxAmount;
        if($.isNumeric(min_limit) || $.isNumeric(max_limit)) {
            var min_limit_calc = parseFloat(min_limit*currencyRate).toFixed(2);
            var max_limit_clac = parseFloat(max_limit*currencyRate).toFixed(2);
            $('.limit-show').html("<?php echo e(__('limit')); ?> " + min_limit_calc + " " + currencyCode + " - " + max_limit_clac + " " + currencyCode);

            return {
                minLimit:min_limit_calc,
                maxLimit:max_limit_clac,
            };
        }else {
            $('.limit-show').html("--");
            return {
                minLimit:0,
                maxLimit:0,
            };
        }
    }
    function acceptVar() {
        var selectedVal = $("select[name=currency] :selected");
        var currencyCode = $("select[name=currency] :selected").val();
        var currencyRate = $("select[name=currency] :selected").data('rate');
        var currencyMinAmount ="<?php echo e(getAmount($topupCharge->min_limit)); ?>";
        var currencyMaxAmount = "<?php echo e(getAmount($topupCharge->max_limit)); ?>";
        var currencyFixedCharge = "<?php echo e(getAmount($topupCharge->fixed_charge)); ?>";
        var currencyPercentCharge = "<?php echo e(getAmount($topupCharge->percent_charge)); ?>";
        var topUp = $("select[name=topup_type] :selected");
        var topUpname = $("select[name=topup_type] :selected").data("name");
        var mobileCode = $("select[name=mobile_code] :selected").val();
        var mobileNumber = $("input[name=mobile_number]").val();

        return {
            currencyCode:currencyCode,
            currencyRate:currencyRate,
            currencyMinAmount:currencyMinAmount,
            currencyMaxAmount:currencyMaxAmount,
            currencyFixedCharge:currencyFixedCharge,
            currencyPercentCharge:currencyPercentCharge,
            topUpname:topUpname,
            mobileNumber:mobileNumber,
            mobileCode:mobileCode,
            topUp:topUp,
            selectedVal:selectedVal,

        };
    }
    function feesCalculation() {
        var currencyCode = acceptVar().currencyCode;
        var currencyRate = acceptVar().currencyRate;
        var sender_amount = $("input[name=amount]").val();
        sender_amount == "" ? (sender_amount = 0) : (sender_amount = sender_amount);

        var fixed_charge = acceptVar().currencyFixedCharge;
        var percent_charge = acceptVar().currencyPercentCharge;
        if ($.isNumeric(percent_charge) && $.isNumeric(fixed_charge) && $.isNumeric(sender_amount)) {
            // Process Calculation
            var fixed_charge_calc = parseFloat(currencyRate * fixed_charge);
            var percent_charge_calc = (parseFloat(sender_amount) / 100) * parseFloat(percent_charge);
            var total_charge = parseFloat(fixed_charge_calc) + parseFloat(percent_charge_calc);
            total_charge = parseFloat(total_charge).toFixed(2);
            // return total_charge;
            return {
                total: total_charge,
                fixed: fixed_charge_calc,
                percent: percent_charge,
            };
        } else {
            // return "--";
            return false;
        }
    }
    function getFees() {
        if(acceptVar().topUp.val() === "null"){
            return false;
        }
        var currencyCode = acceptVar().currencyCode;
        var percent = acceptVar().currencyPercentCharge;
        var charges = feesCalculation();
        if (charges == false) {
            return false;
        }
        $(".fees-show").html("<?php echo e(__('TopUp Fee')); ?>: " + parseFloat(charges.fixed).toFixed(2) + " " + currencyCode + " + " + parseFloat(charges.percent).toFixed(2) + "%  ");
    }
    function activeItems(){
        var topUp = acceptVar().topUp.val();
        if(topUp === undefined || topUp === '' || topUp === null){
            return false;
        }else{
            return getPreview();
        }
    }
    function getPreview() {
            var senderAmount = $("input[name=amount]").val();
            var sender_currency = acceptVar().currencyCode;
            var sender_currency_rate = acceptVar().currencyRate;
            var topup_type = acceptVar().topUpname;
            var mobile_number = acceptVar().mobileNumber;
            var mobile_code = acceptVar().mobileCode;
            senderAmount == "" ? senderAmount = 0 : senderAmount = senderAmount;

            $(".sending-wallet").text(sender_currency + " (" + acceptVar().selectedVal.data('sender-country-name') + ")");
            // Sending Amount
            $('.request-amount').text(senderAmount + " " + sender_currency);
            //topup type
            $('.topup-type').text(topup_type);
            // Fees
            //topup number
            if(mobile_number == '' || mobile_number == 0){
                $('.mobile-number').text("Ex: +1234567891");
            }else{
                $('.mobile-number').text("+"+mobile_code+mobile_number);
            }

            // Fees
            var charges = feesCalculation();
            var total_charge = 0;
            if(senderAmount == 0){
                total_charge = 0;
            }else{
                total_charge = charges.total;
            }

            $('.fees').text(total_charge + " " + sender_currency);

            // Pay In Total
            var totalPay = parseFloat(senderAmount)
            var pay_in_total = 0;
            if(senderAmount == 0){
                pay_in_total = 0;
            }else{
                pay_in_total =  parseFloat(totalPay) + parseFloat(charges.total);
            }
            $('.payable-total').text(parseFloat(pay_in_total).toFixed(2) + " " + sender_currency);

    }
    function enterLimit(){
        var currencyRate = acceptVar().currencyRate;
        var min_limit = parseFloat("<?php echo e(getAmount($topupCharge->min_limit)); ?>") * parseFloat(currencyRate);
        var max_limit =parseFloat("<?php echo e(getAmount($topupCharge->max_limit)); ?>") * parseFloat(currencyRate);
        var sender_amount = parseFloat($("input[name=amount]").val());

        if( sender_amount < min_limit ){
            throwMessage('error',['<?php echo e(__("Please follow the mimimum limit")); ?>']);
            $('.mobileTopupBtn').attr('disabled',true)
        }else if(sender_amount > max_limit){
            throwMessage('error',['<?php echo e(__("Please follow the maximum limit")); ?>']);
            $('.mobileTopupBtn').attr('disabled',true)
        }else{
            $('.mobileTopupBtn').attr('disabled',false)
        }
    }
    function senderBalance() {
            var senderCurrency = acceptVar().currencyCode;
            var csrfToken = $('meta[name="csrf-token"]').attr('content');
            $.ajax({
                type: 'POST',
                url: "<?php echo e(route('agent.wallets.balance')); ?>",
                data: {
                    target: senderCurrency,
                    _token: csrfToken
                },
                success: function(response) {
                    $('.balance-show').html("<?php echo e(__('Available Balance')); ?>: " + parseFloat(response.data).toFixed(2) + " " + senderCurrency);
                }
            });
    }
    function getExchangeRate(){
        var sender_currency = acceptVar().currencyCode;
        var sender_currency_rate = acceptVar().currencyRate;
        var rate = parseFloat(sender_currency_rate);
        $('.exchange-rate').html("1 " + defualCurrency + " = " + parseFloat(rate).toFixed(2) + " " + sender_currency);

        return rate;
    }

</script>


<?php $__env->stopPush(); ?>

<?php echo $__env->make('agent.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp 8.0.2\htdocs\simple-pay\resources\views/agent/sections/mobile-top/manual.blade.php ENDPATH**/ ?>