<?php

namespace App\Http\Controllers\Api\User;

use App\Models\Receipient;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Constants\GlobalConst;
use App\Http\Helpers\Api\Helpers;
use App\Models\Admin\BasicSettings;
use App\Models\RemitanceCashPickup;
use App\Http\Controllers\Controller;
use App\Models\Admin\Currency;
use App\Models\RemitanceBankDeposit;
use App\Models\User;
use Exception;
use Illuminate\Support\Facades\Validator;

class RecipientController extends Controller
{
    public function recipientList(){
        $recipients = Receipient::auth()->orderByDesc("id")->get()->map(function($data){
            $basic_settings = BasicSettings::first();
            if($data->type == Str::slug(GlobalConst::TRX_WALLET_TO_WALLET_TRANSFER)){
                return[
                    'id' => $data->id,
                    'country' => $data->country,
                    'country_name' => $data->receiver_country->country,
                    'trx_type' => $data->type,
                    'trx_type_name' => $basic_settings->site_name.' Wallet',
                    'alias' => $data->alias,
                    'firstname' => $data->firstname,
                    'lastname' => $data->lastname,
                    'mobile_code' => $data->mobile_code??'',
                    'mobile' => $data->mobile,
                    'email'  => $data->email,
                    'account_number' => $data->account_number??'',
                    'institution_name' => $data->institution_name??'',
                    'receiver_country_name' => $data->receiver_country_name??'',
                    'wallet' => $data->wallet??'',
                    'city' => $data->city,
                    'state' => $data->state,
                    'address' => $data->address,
                    'zip_code' => $data->zip_code,
                    'created_at' => $data->created_at,
                    'updated_at' => $data->updated_at,

                ];
            }else{
                return[
                    'id' => $data->id,
                    'country' => $data->country,
                    'country_name' => $data->receiver_country->country,
                    'trx_type' => @$data->type,
                    'trx_type_name' => ucwords(str_replace('-', ' ', @$data->type)),
                    'alias' => $data->alias,
                    'firstname' => $data->firstname,
                    'lastname' => $data->lastname,
                    'mobile_code' => $data->mobile_code??'',
                    'mobile' => $data->mobile,
                    'email'  => $data->email,
                    'account_number' => $data->account_number??'',
                    'institution_name' => $data->institution_name??'',
                    'wallet' => $data->wallet??'',
                    'receiver_country_name' => $data->receiver_country_name??'',
                    'city' => $data->city,
                    'state' => $data->state,
                    'address' => $data->address,
                    'zip_code' => $data->zip_code,
                    'created_at' => $data->created_at,
                    'updated_at' => $data->updated_at,

                ];

            }

        });
        $receiverCountries = Currency::receiver()->active()->orderBy('id',"DESC")->get()->map(function($item){
            return [
                'id' => $item->id,
                'country' => $item->country,
                'name' => $item->name,
                'code' => $item->code,
                'mobile_code' =>get_country_phone_code($item->country),
                'symbol' => $item->symbol,
                'type' => $item->type,
                'flag' => $item->flag,
                'rate' => $item->rate,
                'default' => $item->default,
                'status' => $item->status,
                'created_at' => $item->created_at,
                'currencyImage' => $item->currencyImage,
            ];

        });
        $data =[
            'recipients'   => $recipients,
            'countryFlugPath'   => 'public/backend/images/country-flag',
            'default_image'    => "public/backend/images/default/default.webp",
            'receiverCountries'   => $receiverCountries,
        ];
        $message =  ['success'=>[__('All Recipient')]];
        return Helpers::success($data,$message);
    }
    public function saveRecipientInfo(){
        $basic_settings = BasicSettings::first();
        $transactionType = [
            [
                'id'    => 1,
                'field_name' => Str::slug(GlobalConst::TRX_BANK_TRANSFER),
                'label_name' => "Bank Transfer",
            ],
            [
                'id'    => 2,
                'field_name' =>Str::slug(GlobalConst::TRX_WALLET_TO_WALLET_TRANSFER),
                'label_name' => $basic_settings->site_name.' Wallet',
            ],

            [
                'id'    => 3,
                'field_name' => Str::slug(GlobalConst::TRX_CASH_PICKUP),
                'label_name' => "Cash Pickup",
            ]
         ];
          $transaction_type = (array) $transactionType;

          $receiverCountries = Currency::receiver()->active()->orderBy('id',"DESC")->get()->map(function($item){
            return [
                'id' => $item->id,
                'country' => $item->country,
                'name' => $item->name,
                'code' => $item->code,
                'mobile_code' =>get_country_phone_code($item->country),
                'symbol' => $item->symbol,
                'type' => $item->type,
                'flag' => $item->flag,
                'rate' => $item->rate,
                'default' => $item->default,
                'status' => $item->status,
                'created_at' => $item->created_at,
                'currencyImage' => $item->currencyImage,
            ];

        });
        $banks = RemitanceBankDeposit::active()->latest()->get();
        $cashPickups = RemitanceCashPickup::active()->latest()->get();
        $data =[
            'base_curr' => get_default_currency_code(),
            'countryFlugPath'   => 'public/backend/images/country-flag',
            'default_image'    => "public/backend/images/default/default.webp",
            'transactionTypes'   => $transaction_type,
            'receiverCountries'   => $receiverCountries,
            'banks'   => $banks,
            'cashPickupsPoints'   => $cashPickups,
        ];
        $message =  ['success'=>[__('Save Recipient Information')]];
        return Helpers::success($data,$message);
    }
    public function dynamicFields(){
        $bank_deposit = [
            [
                'field_name' => "transaction_type",
                'label_name' => "Transaction Type",
            ],
            [
                'field_name' => "firstname",
                'label_name' => "First Name",
            ],
            [
                'field_name' => "lastname",
                'label_name' => "Last Name",
            ],
            [
                'field_name' => "account_number",
                'label_name' => "IBAN/EID",
            ],
            [
                'field_name' => "institution_name",
                'label_name' => "Swift Code/BIC/Institution Name",
            ],
            [
                'field_name' => "country",
                'label_name' => "Wallet Currency",
            ],
            [
                'field_name' => "receiver_country",
                'label_name' => "Receiver Country",
            ],
            [
                'field_name' => "address",
                'label_name' => "Address ",
            ],
            [
                'field_name' => "state",
                'label_name' => "State",
            ],
            [
                'field_name' => "city",
                'label_name' => "City",
            ],
            [
                'field_name' => "zip",
                'label_name' => "Zip Code",
            ],
            [
                'field_name' => "wallet",
                'label_name' => "Wallet",
            ],
            [
                'field_name' => "mobile_code",
                'label_name' => "Dial Code",
            ],
            [
                'field_name' => "mobile",
                'label_name' => "Phone Number",
            ],
            [
                'field_name' => "email",
                'label_name' => "Email Address",
            ],
            [
                'field_name' => "bank",
                'label_name' => "Select Bank",
            ],


        ];
        $bank_deposit = (array) $bank_deposit;

        $wallet_to_wallet = [
            [
                'field_name' => "transaction_type",
                'label_name' => "Transaction Type",
            ],
            [
                'field_name' => "mobile_code",
                'label_name' => "Dial Code",
            ],
            [
                'field_name' => "country",
                'label_name' => "Wallet Currency",
            ],
            [
                'field_name' => "receiver_country",
                'label_name' => "Receiver Country",
            ],

            [
                'field_name' => "email",
                'label_name' => "Email Address",
            ],
            [
                'field_name' => "mobile",
                'label_name' => "Phone Number",
            ],

            [
                'field_name' => "firstname",
                'label_name' => "First Name",
            ],
            [
                'field_name' => "lastname",
                'label_name' => "Last Name",
            ],

            [
                'field_name' => "address",
                'label_name' => "Address ",
            ],
            [
                'field_name' => "state",
                'label_name' => "State",
            ],
            [
                'field_name' => "city",
                'label_name' => "City",
            ],
            [
                'field_name' => "zip",
                'label_name' => "Zip Code",
            ]


        ];
        $wallet_to_wallet = (array) $wallet_to_wallet;

        $cash_pickup = [
            [
                'field_name' => "transaction_type",
                'label_name' => "Transaction Type",
            ],
            [
                'field_name' => "firstname",
                'label_name' => "First Name",
            ],
            [
                'field_name' => "lastname",
                'label_name' => "Last Name",
            ],
            [
                'field_name' => "country",
                'label_name' => "Wallet Currency",
            ],
            [
                'field_name' => "receiver_country",
                'label_name' => "Receiver Country",
            ],
            [
                'field_name' => "address",
                'label_name' => "Address ",
            ],
            [
                'field_name' => "state",
                'label_name' => "State",
            ],
            [
                'field_name' => "city",
                'label_name' => "City",
            ],
            [
                'field_name' => "zip",
                'label_name' => "Zip Code",
            ],
            [
                'field_name' => "mobile_code",
                'label_name' => "Dial Code",
            ],
            [
                'field_name' => "mobile",
                'label_name' => "Phone Number",
            ],
            [
                'field_name' => "email",
                'label_name' => "Email Address",
            ],
            [
                'field_name' => "cash_pickup",
                'label_name' => "Pickup Point",
            ],

         ];
          $cash_pickup = (array) $cash_pickup;
      $message =  ['success'=>[__('Recipient Store/Update Fields Name')]];
      $data = [
        Str::slug(GlobalConst::TRX_BANK_TRANSFER) => $bank_deposit,
        Str::slug(GlobalConst::TRX_WALLET_TO_WALLET_TRANSFER) => $wallet_to_wallet,
        Str::slug(GlobalConst::TRX_CASH_PICKUP) => $cash_pickup,
      ];
      return Helpers::success($data,$message);

    }
    public function checkUser(Request $request){
        $validator = Validator::make(request()->all(), [
            'email' => 'required|email',
            'country_name' => 'required|string',
        ]);
        if($validator->fails()){
            $error =  ['error'=>$validator->errors()->all()];
            return Helpers::validation($error);
        }
        $validated = $validator->validate();
        $field_name = "email";
        try{
            $user = User::where($field_name,$validated['email'])->first();
            // if($user != null) {
            //     if(auth()->user()->email ===  $user->email){
            //         $error = ['error'=>[__("Can't send remittance to your own")]];
            //         return Helpers::error($error);
            //     }
            //     if($user->address->country == null ||  @$user->address->country !=  $validated['country_name']) {
            //         $error = ['error'=>[__("The user's country does not match the selected country.")]];
            //         return Helpers::error($error);
            //     }
            // }
            if(!$user){
                $error = ['error'=>[__('User not found')]];
                return Helpers::error($error);
            }
            $data =[
                'user' => $user,
            ];
            $message =  ['success'=>[__('Successfully get user')]];
            return Helpers::success($data,$message);
        }catch(Exception $e) {
            $error = ['error'=>[__("Something went wrong! Please try again.")]];
            return Helpers::error($error);
        }
    }
    public function getBankCharges(){
        $validator = Validator::make(request()->all(), [
            'alias' => 'required|string'
        ]);
        if($validator->fails()){
            $error =  ['error'=>$validator->errors()->all()];
            return Helpers::validation($error);
        }
        $validated = $validator->validate();
        $charges = RemitanceBankDeposit::where('alias',$validated['alias'])->first();
        if(!$charges){
            $error = ['error'=>[__('Invalid request')]];
            return Helpers::error($error);
        }
        $charges = RemitanceBankDeposit::where('alias',$validated['alias'])->get()->map(function($data){
            return[
                'name' => $data->name,
                'code' => $data->code,
                'rate' => getAmount($data->rate,2),
                'fixed_charge' => getAmount($data->fixed_charge,2),
                'percent_charge' => getAmount($data->percent_charge,2),
                'min_limit' => getAmount($data->min_limit,2),
                'max_limit' => getAmount($data->max_limit,2),
                'monthly_limit' => getAmount($data->monthly_limit,2),
                'daily_limit' => getAmount($data->daily_limit,2),
                'agent_fixed_commissions' => getAmount($data->agent_fixed_commissions,2),
                'agent_percent_commissions' => getAmount($data->agent_percent_commissions,2),
                'agent_profit' => $data->agent_profit,
                'status' => $data->status,
            ];
        });
        $message =  ['success'=>[__('Successfully get information')]];
        return Helpers::success($charges,$message);
    }
    public function storeRecipient(Request $request){
        $user = auth()->user();
        if($request->transaction_type == 'bank-transfer') {
            $bankRules = 'required|string';
             $account_number = 'required|regex:/^[A-Za-z0-9@.]+$/|min:5|max:50';
            $institution_name = 'required|string|max:100';
            $wallet = 'required|string|max:10';
        }else {
            $bankRules = 'nullable|string';
            $account_number = 'nullable|string';
            $institution_name = 'nullable|string|max:100';
            $wallet = 'nullable|string|max:10';
        }

        if($request->transaction_type == 'cash-pickup') {
            $cashPickupRules = "required|string";
        }else {
            $cashPickupRules = "nullable";
        }

        $validator = Validator::make(request()->all(), [
            'transaction_type'              =>'required|string',
            'country'                      =>'required',
            'receiver_country'           =>'required',
            'firstname'                      =>'required|string',
            'lastname'                      =>'required|string',
            'email'                      =>"required|email",
            'mobile'                      =>"required",
            'mobile_code'                 =>'nullable',
            'city'                      =>'required|string',
            'address'                      =>'required|string',
            'state'                      =>'required|string',
            'zip'                      =>'required|string',
            'bank'                      => $bankRules,
            'cash_pickup'               => $cashPickupRules,
            'account_number'             => $account_number,
            'institution_name'           => $institution_name,
            'wallet'                     => $wallet,
        ], [
            'account_number.required'    => __('The account number is required for bank transfers.'),
            'account_number.regex'       => __('The account number must contain only letters and numbers.'),
            'account_number.min'         => __('The account number must be at least 5 characters long.'),
            'account_number.max'         => __('The account number cannot exceed 50 characters.'),
            // Add other custom messages here if needed
        ]);

        if($validator->fails()){
            $error =  ['error'=>$validator->errors()->all()];
            return Helpers::validation($error);
        }
        $checkMobile = Receipient::where('user_id',$user->id)->where('email',$request->email)->first();
        if($checkMobile){
            $error = ['error'=>[__('This recipient  already exist.!')]];
            return Helpers::error($error);
        }
        $country =  Currency::active()->where('id',$request->country)->first();
        if(!$country){
            $error = ['error'=>[__('Please select a valid country!')]];
            return Helpers::error($error);
        }
        $countryId = $country->id;

        if($request->transaction_type == 'bank-transfer') {
            $alias  = $request->bank;
            $details = RemitanceBankDeposit::where('alias',$alias)->first();
            if( !$details){
                $error = ['error'=>[__('Please select a valid bank!')]];
                return Helpers::error($error);
            }
        }elseif($request->transaction_type == 'cash-pickup'){
            $alias  = $request->cash_pickup;
            $details = RemitanceCashPickup::where('alias',$alias)->first();
            if( !$details){
                $error = ['error'=>[__('Please select a valid cash pickup!')]];
                return Helpers::error($error);
            }
        }elseif($request->transaction_type == "wallet-to-wallet-transfer"){
            $receiver = User::active()->where('email',$request->email)->first();
            if( !$receiver){
                $error = ['error'=>[__('User not found!')]];
                return Helpers::error($error);
            }
            $details = $receiver;
            $alias  = $request->transaction_type;

        }

        $in['user_id'] =  $user->id;
        $in['country'] =   $countryId;
        $in['receiver_country_name'] = $request->receiver_country;
        $in['type'] = $request->transaction_type;
        $in['alias'] =   $alias;
        $in['firstname'] = $request->firstname;
        $in['lastname'] = $request->lastname;
        $in['state'] = $request->state;
        $in['email'] = $request->email;
        $in['mobile_code'] = remove_speacial_char($request->mobile_code)??null;
        $in['mobile'] = remove_speacial_char($request->mobile_code) == "880"?(int)remove_speacial_char($request->mobile):remove_speacial_char($request->mobile) ;
        $in['city'] = $request->city;
        $in['address'] = $request->address;
        $in['zip_code'] = $request->zip;
        $in['account_number']   = $request->account_number??null;
        $in['institution_name'] = $request->institution_name??null;
        $in['wallet']           = $request->wallet??null;
        $in['details'] = json_encode($details);
        try{
            Receipient::create($in);
            $message =  ['success'=>[__('Receipient save successfully')]];
            return Helpers::onlysuccess($message);
        }catch(Exception $e) {
            $error = ['error'=>[__("Something went wrong! Please try again.")]];
            return Helpers::error($error);
        }

    }
    public function editRecipient(){
        $validator = Validator::make(request()->all(), [
            'id'              =>'required',
        ]);
        if($validator->fails()){
            $error =  ['error'=>$validator->errors()->all()];
            return Helpers::validation($error);
        }
        $recipient =  Receipient::auth()->with('user','receiver_country')->where('id',request()->id)->get()->map(function($item){
            return[
                'id' => $item->id,
                'country' => $item->country,
                'type' => $item->type,
                'alias' => $item->alias,
                'firstname' => $item->firstname,
                'lastname' => $item->lastname,
                'mobile_code' => $item->mobile_code??'',
                'mobile' => $item->mobile,
                'email'  => $item->email,
                'account_number' => $item->account_number??'',
                'institution_name' => $item->institution_name??'',
                'wallet' => $item->wallet??'',
                'receiver_country_name' => $item->receiver_country_name??'',
                'city' => $item->city,
                'address' => $item->address,
                'state' => $item->state,
                'zip_code' => $item->zip_code,
                'created_at' => $item->created_at,
                'updated_at' => $item->updated_at,

            ];
        })->first();
        if( !$recipient){
            $error = ['error'=>[__('Invalid request, recipient not found!')]];
            return Helpers::error($error);
        }
        $basic_settings = BasicSettings::first();
        $transactionType = [
            [
                'id'    => 1,
                'field_name' => Str::slug(GlobalConst::TRX_BANK_TRANSFER),
                'label_name' => "Bank Transfer",
            ],
            [
                'id'    => 2,
                'field_name' =>Str::slug(GlobalConst::TRX_WALLET_TO_WALLET_TRANSFER),
                'label_name' => $basic_settings->site_name.' Wallet',
            ],

            [
                'id'    => 3,
                'field_name' => Str::slug(GlobalConst::TRX_CASH_PICKUP),
                'label_name' => "Cash Pickup",
            ]
         ];
          $transaction_type = (array) $transactionType;

          $receiverCountries = Currency::receiver()->active()->orderBy('id',"DESC")->get()->map(function($item){
            return [
                'id' => $item->id,
                'country' => $item->country,
                'name' => $item->name,
                'code' => $item->code,
                'mobile_code' =>get_country_phone_code($item->country),
                'symbol' => $item->symbol,
                'type' => $item->type,
                'flag' => $item->flag,
                'rate' => $item->rate,
                'default' => $item->default,
                'status' => $item->status,
                'created_at' => $item->created_at,
                'currencyImage' => $item->currencyImage,
            ];

        });

        $banks = RemitanceBankDeposit::active()->latest()->get();
        $cashPickups = RemitanceCashPickup::active()->latest()->get();
        $data =[
            'recipient' => (object)$recipient,
            'base_curr' => get_default_currency_code(),
            'countryFlugPath'   => 'public/backend/images/country-flag',
            'default_image'    => "public/backend/images/default/default.webp",
            'transactionTypes'   => $transaction_type,
            'receiverCountries'   => $receiverCountries,
            'banks'   => $banks,
            'cashPickupsPoints'   => $cashPickups,
        ];
        $message =  ['success'=>[__('Successfully get recipient')]];
        return Helpers::success($data,$message);
    }
    public function updateRecipient(Request $request){

        if($request->transaction_type == 'bank-transfer') {
            $bankRules = 'required|string';
             $account_number = 'required|regex:/^[A-Za-z0-9@.]+$/|min:5|max:50';
            $institution_name = 'required|string|max:100';
            $wallet = 'required|string|max:10';
        }else {
            $bankRules = 'nullable|string';
            $account_number = 'nullable|string';
            $institution_name = 'nullable|string|max:100';
            $wallet = 'nullable|string|max:10';
        }

        if($request->transaction_type == 'cash-pickup') {
            $cashPickupRules = "required|string";
        }else {
            $cashPickupRules = "nullable";
        }
        $validator = Validator::make(request()->all(), [
            'id'              =>'required|string',
            'transaction_type'              =>'required|string',
            'country'                      =>'required',
            'receiver_country'           =>'required',
            'firstname'                      =>'required|string',
            'lastname'                      =>'required|string',
            'email'                      =>"required|email",
            'mobile'                      =>"required",
            'mobile_code'                      =>'nullable',
            'city'                      =>'required|string',
            'address'                      =>'required|string',
            'state'                      =>'required|string',
            'zip'                      =>'required|string',
            'bank'                      => $bankRules,
            'cash_pickup'               => $cashPickupRules,
            'account_number'                => $account_number,
            'institution_name'              => $institution_name,
            'wallet'                        => $wallet,

        ], [
            'account_number.required'    => __('The account number is required for bank transfers.'),
            'account_number.regex'       => __('The account number must contain only letters and numbers.'),
            'account_number.min'         => __('The account number must be at least 5 characters long.'),
            'account_number.max'         => __('The account number cannot exceed 50 characters.'),
            // Add other custom messages here if needed
        ]);

        if($validator->fails()){
            $error =  ['error'=>$validator->errors()->all()];
            return Helpers::validation($error);
        }
        $user = auth()->user();
        $data =  Receipient::auth()->with('user','receiver_country')->where('id',$request->id)->first();
        if( !$data){
            $error = ['error'=>[__('Invalid request, recipient not found!')]];
            return Helpers::error($error);
        }
        $checkMobile = Receipient::where('id','!=',$data->id)->where('user_id',$user->id)->where('email',$request->email)->first();
        if($checkMobile){
            $error = ['error'=>[__('This recipient  already exist.')]];
            return Helpers::error($error);
        }

        $country =  Currency::active()->where('id',$request->country)->first();
        if(!$country){
            $error = ['error'=>[__('Please select a valid country')]];
            return Helpers::error($error);
        }
        $countryId = $country->id;
        if($request->transaction_type == 'bank-transfer') {
            $alias  = $request->bank;
            $details = RemitanceBankDeposit::where('alias',$alias)->first();
            if( !$details){
                $error = ['error'=>[__('Please select a valid bank')]];
                return Helpers::error($error);
            }
        }elseif($request->transaction_type == 'cash-pickup'){
            $alias  = $request->cash_pickup;
            $details = RemitanceCashPickup::where('alias',$alias)->first();
            if( !$details){
                $error = ['error'=>[__('Please select a valid cash pickup')]];
                return Helpers::error($error);
            }
        }elseif($request->transaction_type == "wallet-to-wallet-transfer"){
            $receiver = User::where('email',$request->email)->first();
            if( !$receiver){
                $error = ['error'=>[__('User not found')]];
                return Helpers::error($error);
            }
            $details = $receiver;
            $alias  = $request->transaction_type;
        }

        $in['user_id'] =  $user->id;
        $in['country'] =   $countryId;
        $in['receiver_country_name'] = $request->receiver_country;
        $in['type'] = $request->transaction_type;
        $in['alias'] =   $alias;
        $in['firstname'] = $request->firstname;
        $in['lastname'] = $request->lastname;
        $in['email'] = $request->email;
        $in['state'] = $request->state;
        $in['mobile_code'] = remove_speacial_char($request->mobile_code)??null;
        $in['mobile'] = remove_speacial_char($request->mobile_code) == "880"?(int)remove_speacial_char($request->mobile):remove_speacial_char($request->mobile) ;
        $in['city'] = $request->city;
        $in['address'] = $request->address;
        $in['zip_code'] = $request->zip;
        $in['account_number']   = $request->account_number??null;
        $in['institution_name'] = $request->institution_name??null;
        $in['wallet']           = $request->wallet??null;
        $in['details'] = json_encode($details);
        try{
            $data->fill($in)->save();
            $message =  ['success'=>[__('Receipient updated successfully')]];
            return Helpers::onlysuccess($message);
        }catch(Exception $e) {
            $error = ['error'=>[__("Something went wrong! Please try again.")]];
            return Helpers::error($error);
        }

    }
    public function deleteRecipient(Request $request){
        $validator = Validator::make(request()->all(), [
            'id'              =>'required',
        ]);
        if($validator->fails()){
            $error =  ['error'=>$validator->errors()->all()];
            return Helpers::validation($error);
        }
        $recipient = Receipient::where('id',$request->id)->first();
        if(!$recipient){
            $error = ['error'=>[__('Invalid request')]];
            return Helpers::error($error);
        }
        try{
            $recipient->delete();
            $message =  ['success'=>[__('Receipient deleted successfully!')]];
            return Helpers::onlysuccess($message);
        }catch(Exception $e) {
            $error = ['error'=>[__("Something went wrong! Please try again.")]];
            return Helpers::error($error);
        }

    }

}
