@extends('admin.layouts.master')

@push('css')
    <style>
        .fileholder {
            min-height: 194px !important;
        }

        .fileholder-files-view-wrp.accept-single-file .fileholder-single-file-view,.fileholder-files-view-wrp.fileholder-perview-single .fileholder-single-file-view{
            height: 150px !important;
        }
    </style>
@endpush

@section('page-title')
    @include('admin.components.page-title',['title' => __($page_title)])
@endsection

@section('breadcrumb')
    @include('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ]
    ], 'active' => __("Setup Agent Group")])
@endsection

@section('content')
    <div class="table-area">
        <div class="table-wrapper">
            <div class="table-header">
                <h5 class="title">{{ __("Setup Group") }}</h5>
                <div class="table-btn-area">
                    @include('admin.components.search-input',[
                        'name'  => 'group_search',
                    ])
                    @include('admin.components.link.add-default',[
                        'text'          => __("Add Group"),
                        'href'          =>  setRoute("admin.setup.group.agents.create"),
                        'class'         => "modal-btn",
                        'permission'    => "admin.setup.group.agents.create",
                    ])
                </div>
            </div>
            <div class="table-responsive">
                @include('admin.components.data-table.agent-group-table',[
                    'data'  => $allGroups
                ])
            </div>
        </div>
        {{ get_paginate($allGroups) }}
    </div>


@endsection

@push('script')
    <script>

        $(".delete-modal-button").click(function(){
            var oldData = JSON.parse($(this).parents("tr").attr("data-item"));
            var actionRoute =  "{{ setRoute('admin.setup.group.agents.delete') }}";
            var target      = oldData.id;
            var message     = `Are you sure to delete <strong>${oldData.name}</strong> Group?`;
            openDeleteModal(actionRoute,target,message);
        });

        itemSearch($("input[name=group_search]"),$(".group-search-table"),"{{ setRoute('admin.setup.group.agents.search') }}",1);
    </script>
@endpush
