@extends('admin.layouts.master')

@push('css')

@endpush

@section('page-title')
    @include('admin.components.page-title',['title' => __($page_title)])
@endsection

@section('breadcrumb')
    @include('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ]
    ], 'active' => __("User Group Fees & Charges")])
@endsection

@section('content')
<form class="card-form" method="POST" action="{{ setRoute('admin.setup.group.users.update') }}">
    @csrf
    @method("PUT")
    <input type="hidden" name="group_id" value="{{ $group->id }}">
    <div class="custom-card mb-10">
        <div class="card-header">
            <h6 class="title">{{ "Basic Informations" }}</h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-xl-6 col-lg-6 mb-10">
                    <div class="custom-inner-card">
                        <div class="card-inner-header">
                            <h5 class="title">{{ __("Group Name") }}</h5>
                        </div>
                        <div class="card-inner-body">
                            <div class="row">
                                <div class="col-xl-12 col-lg-12 form-group">
                                    <input type="text" placeholder="{{ __('Enter Group Name') }}" name="group_name" class="form--control" value="{{ old('group_name',@$group->name ) }}">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 mb-10">
                    <div class="custom-inner-card">
                        <div class="card-inner-header">
                            <h5 class="title">{{ __("Assign Users") }}</h5>
                        </div>
                        <div class="card-inner-body">

                            <div class="row">
                                <div class="col-xl-12 col-lg-12 form-group">
                                    <select name="users[]" multiple id="" class="form--control select2-auto-tokenize" data-placeholder="{{ __("Select Users") }}">
                                        @foreach ($allUsers ?? [] as $user)
                                            @if(in_array($user->id,$assignedGroupUsersOther))
                                            @else
                                            <option value="{{ $user->id }}" @if(in_array($user->id,$assignedGroupUsers))
                                                selected
                                            @endif>{{ ucwords($user->fullname) }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row mb-10-none">
        <div class="col-xl-12 col-lg-12 form-group">
            @include('admin.components.button.form-btn',[
                'text'          =>   __("Update Group Informations")  ,
                'class'         => "w-100 btn-loading",
                'permission'    => "admin.setup.group.users.update",
            ])
        </div>
    </div>
</form>
    @foreach ($transaction_charges as $item)
        @include('admin.components.charge-group.user-trx-settings-charge-block-edit',[
            'route'         => setRoute('admin.setup.group.users.trx.update'),
            'title'         => $item->title,
            'data'          => $item,
        ])
    @endforeach
@endsection

@push('script')

@endpush
