<?php

namespace Database\Seeders\Admin;

use App\Models\Admin\Currency;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CurrencySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $currencies = array(
            array('admin_id' => '1','country' => 'United States','name' => 'United States dollar','code' => 'USD','symbol' => '$','type' => 'FIAT','flag' => 'seeder/currency-flug.webp','rate' => '1.00000000','sender' => '1','receiver' => '1','default' => '1','status' => '1','created_at' => '2024-08-13 18:36:43','updated_at' => '2024-08-13 18:36:43'),
            array('admin_id' => '1','country' => 'United Kingdom','name' => 'British pound','code' => 'GBP','symbol' => '£','type' => 'FIAT','flag' => NULL,'rate' => '0.79000000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => '2024-08-13 18:36:43','updated_at' => '2024-08-13 18:36:43'),
            array('admin_id' => '1','country' => 'Australia','name' => 'Australian dollar','code' => 'AUD','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '1.50000000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => '2024-08-13 18:36:43','updated_at' => '2024-08-13 18:36:43'),
            array('admin_id' => '1','country' => 'Canada','name' => 'Canadian dollar','code' => 'CAD','symbol' => '$','type' => 'FIAT','flag' => NULL,'rate' => '1.37000000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => '2024-08-13 18:36:43','updated_at' => '2024-08-13 18:36:43'),
            array('admin_id' => '1','country' => 'Germany','name' => 'Euro','code' => 'EUR','symbol' => '€','type' => 'FIAT','flag' => NULL,'rate' => '0.93000000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => '2024-08-13 18:36:43','updated_at' => '2024-08-13 18:36:43'),
            array('admin_id' => '1','country' => 'Nigeria','name' => 'Nigerian naira','code' => 'NGN','symbol' => '₦','type' => 'FIAT','flag' => NULL,'rate' => '1490.00000000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => '2024-08-13 18:36:43','updated_at' => '2024-08-13 18:36:43'),
            array('admin_id' => '1','country' => 'Pakistan','name' => 'Pakistani rupee','code' => 'PKR','symbol' => 'Rs','type' => 'FIAT','flag' => NULL,'rate' => '278.60000000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => '2024-08-13 18:36:43','updated_at' => '2024-08-13 18:36:43'),
            array('admin_id' => '1','country' => 'India','name' => 'Indian rupee','code' => 'INR','symbol' => '₹','type' => 'FIAT','flag' => NULL,'rate' => '83.63000000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => '2024-08-13 18:36:43','updated_at' => '2024-08-13 18:36:43'),
            array('admin_id' => '1','country' => 'Bangladesh','name' => 'Bangladeshi taka','code' => 'BDT','symbol' => '৳','type' => 'FIAT','flag' => NULL,'rate' => '117.54000000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => '2024-08-13 18:36:43','updated_at' => '2024-08-13 18:36:43'),
            array('admin_id' => '1','country' => 'Kenya','name' => 'Kenyan shilling','code' => 'KES','symbol' => 'KSh','type' => 'FIAT','flag' => NULL,'rate' => '128.25000000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => '2024-08-13 18:36:43','updated_at' => '2024-08-13 18:36:43'),
            array('admin_id' => '1','country' => 'Cote D\'Ivoire (Ivory Coast)','name' => 'West African CFA franc','code' => 'XOF','symbol' => 'CFA','type' => 'FIAT','flag' => NULL,'rate' => '610.40000000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => '2024-08-13 18:36:43','updated_at' => '2024-08-13 18:36:43'),
            array('admin_id' => '1','country' => 'United States','name' => 'United States dollar','code' => 'USDT','symbol' => '$','type' => 'CRYPTO','flag' => NULL,'rate' => '1.00000000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => '2024-08-20 10:02:40','updated_at' => '2024-08-20 10:02:40'),
            array('admin_id' => '1','country' => 'El Salvador','name' => 'United States dollar','code' => 'BTC','symbol' => '$','type' => 'CRYPTO','flag' => NULL,'rate' => '0.00001600','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => '2024-08-20 10:30:21','updated_at' => '2024-08-20 10:30:21'),
            array('admin_id' => '1','country' => 'Switzerland','name' => 'Swiss franc','code' => 'ETH','symbol' => 'Ξ','type' => 'CRYPTO','flag' => NULL,'rate' => '0.00038000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => '2024-08-20 10:43:09','updated_at' => '2024-08-20 10:43:33'),
            array('admin_id' => '1','country' => 'United States','name' => 'United States dollar','code' => 'SOL','symbol' => '$','type' => 'CRYPTO','flag' => NULL,'rate' => '0.00690000','sender' => '1','receiver' => '1','default' => '0','status' => '1','created_at' => '2024-08-20 10:46:39','updated_at' => '2024-08-20 10:46:39')
          );

        Currency::upsert($currencies,['country'],['country','name','code','rate']);
    }
}
