<?php $__env->startPush('css'); ?>
<?php
    $rejectedCountries = $data->data ?? []; // Rejected countries
    $allCountries = get_all_countries() ?? []; // All available countries
?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title',['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ]
    ], 'active' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="custom-card">
    <div class="card-header">
        <h6 class="title"><?php echo e(__($page_title)); ?></h6>
        <div class="table-btn-area">
            <?php echo $__env->make('admin.components.link.custom',[
                'href'          => route('admin.country.restriction.index'),
                'class'         => "btn btn--base",
                'text'          =>__("Back"),
                'permission'    => "admin.country.restriction.index",
            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

    </div>
    <div class="card-body">
        <form action="<?php echo e(setRoute('admin.country.restriction.update',$data->slug)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field("PUT"); ?>
            <div class="custom-card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-xl-12 col-lg-12 form-group mt-2">
                            <label for="selectRole"><?php echo e(__("Remove Any Country")); ?></label>
                            <select name="countries[]" id="selectTitle" class="select2-auto-tokenize form--control" data-placeholder="<?php echo e(__("select Country")); ?>" multiple>
                                
                                <?php $__currentLoopData = $rejectedCountries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $countryName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($countryName); ?>"><?php echo e($countryName); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                
                                <?php $__currentLoopData = $allCountries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    
                                    <?php if(!in_array($country->name, $rejectedCountries)): ?>
                                        
                                        <option value="<?php echo e($country->name); ?>" selected><?php echo e($country->name); ?></option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-xl-12 col-lg-12 form-group">
                            <?php echo $__env->make('admin.components.button.form-btn',[
                                'class'         => "w-100 btn-loading",
                                'text'          => __("Save & Change"),
                                'permission'    => "admin.country.restriction.update",
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/admin/sections/country-restriction/edit.blade.php ENDPATH**/ ?>