
<div class="custom-card mb-10">
    <div class="card-header">
        <h6 class="title"><?php echo e($title ?? ""); ?></h6>
    </div>
    <div class="card-body">
        <input type="hidden" value="<?php echo e($data->slug); ?>" name="slug">
        <input type="hidden" value="<?php echo e($data->agent_profit == false ? 0 : 1); ?>" name="<?php echo e($data->slug); ?>_agent_profit">
        <div class="row">
            <div class="<?php echo e($item->agent_profit == true ? 'col-xl-4 col-lg-4': 'col-xl-6 col-lg-6 '); ?> mb-10">
                <div class="custom-inner-card">
                    <div class="card-inner-header">
                        <h5 class="title"><?php echo e(__("Charges")); ?></h5>
                    </div>
                    <div class="card-inner-body">
                        <div class="row">
                            <div class="col-xxl-12 col-xl-6 col-lg-6 form-group">
                                <label><?php echo e(__("Fixed Charge*")); ?></label>
                                <div class="input-group">
                                    <input type="text" placeholder="0.00" class="form--control number-input" value="<?php echo e(old($data->slug.'_fixed_charge')); ?>" name="<?php echo e($data->slug); ?>_fixed_charge">
                                    <span class="input-group-text"><?php echo e(get_default_currency_code($default_currency)); ?></span>
                                </div>
                            </div>
                            <div class="col-xxl-12 col-xl-6 col-lg-6 form-group">
                                <label><?php echo e(__("Percent Charge*")); ?></label>
                                <div class="input-group">
                                    <input type="text" placeholder="0.00" class="form--control number-input" value="<?php echo e(old($data->slug.'_percent_charge')); ?>" name="<?php echo e($data->slug); ?>_percent_charge">
                                    <span class="input-group-text">%</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="<?php echo e($item->agent_profit == true ? 'col-xl-4 col-lg-4': 'col-xl-6 col-lg-6 '); ?> mb-10">
                <div class="custom-inner-card">
                    <div class="card-inner-header">
                        <h5 class="title"><?php echo e(__("Range")); ?></h5>
                    </div>
                    <div class="card-inner-body">
                        <div class="row">
                            <div class="col-xxl-12 col-xl-6 col-lg-6  form-group">
                                <label><?php echo e(__("Minimum amount")); ?></label>
                                <div class="input-group">
                                    <input type="text" class="form--control number-input" placeholder="0.00" value="<?php echo e(old($data->slug.'_min_limit')); ?>" name="<?php echo e($data->slug); ?>_min_limit">
                                    <span class="input-group-text"><?php echo e(get_default_currency_code($default_currency)); ?></span>
                                </div>
                            </div>
                            <div class="col-xxl-12 col-xl-6 col-lg-6 form-group">
                                <label><?php echo e(__("Maximum amount")); ?></label>
                                <div class="input-group">
                                    <input type="text" class="form--control number-input" placeholder="0.00" value="<?php echo e(old($data->slug.'_max_limit')); ?>" name="<?php echo e($data->slug); ?>_max_limit">
                                    <span class="input-group-text"><?php echo e(get_default_currency_code($default_currency)); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php if( $item->agent_profit == true): ?>
                <div class="col-xl-4 col-lg-4 mb-10">
                    <div class="custom-inner-card">
                        <div class="card-inner-header">
                            <h5 class="title-agent"><?php echo e(__("Agent Profits")); ?></h5>
                        </div>
                        <div class="card-inner-body">
                            <div class="row">
                                <div class="col-xxl-12 col-xl-6 col-lg-6 form-group">
                                    <label><?php echo e(__("Fixed Commissions")); ?></label>
                                    <div class="input-group">
                                        <input type="text" placeholder="0.00" class="form--control number-input" value="<?php echo e(old($data->slug.'_agent_fixed_commissions')); ?>" name="<?php echo e($data->slug); ?>_agent_fixed_commissions">
                                        <span class="input-group-text"><?php echo e(get_default_currency_code($default_currency)); ?></span>
                                    </div>
                                </div>
                                <div class="col-xxl-12 col-xl-6 col-lg-6 form-group">
                                    <label><?php echo e(__("Percent Commissions")); ?></label>
                                    <div class="input-group">
                                        <input type="text" placeholder="0.00" class="form--control number-input" value="<?php echo e(old($data->slug.'_agent_percent_commissions')); ?>" name="<?php echo e($data->slug); ?>_agent_percent_commissions">
                                        <span class="input-group-text"><?php echo e(get_default_currency_code($default_currency)); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php else: ?>
            <input type="hidden" class="form--control number-input" value="<?php echo e(old($data->slug.'_agent_fixed_commissions',0)); ?>" name="<?php echo e($data->slug); ?>_agent_fixed_commissions">
            <input type="hidden" class="form--control number-input" value="<?php echo e(old($data->slug.'_agent_percent_commissions',0)); ?>" name="<?php echo e($data->slug); ?>_agent_percent_commissions">

            <?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH E:\xampp 8.0.2\htdocs\simple-pay\resources\views/admin/components/charge-group/user-trx-settings-charge-block.blade.php ENDPATH**/ ?>