<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('user.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("user.dashboard"),
        ]
    ], 'active' => __("Dashboard")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="body-wrapper">
    <div class="dashboard-area mt-10">
        <div class="dashboard-header-wrapper">
            <h3 class="title"><?php echo e(__("My Wallets")); ?></h3>
            <div class="dashboard-btn-wrapper">
                <div class="dashboard-btn">
                    <a href="<?php echo e(setRoute('user.wallets.index')); ?>" class="btn--base"><?php echo e(__("View More")); ?></a>
                </div>
            </div>
        </div>
        <?php echo $__env->make('user.components.wallets.fiat',compact("fiat_wallets"), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    <div class="dashboard-area mt-20">
        <?php echo $__env->make('user.components.wallets.crypto',compact("crypto_wallets"), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <div class="dashboard-area mt-10">
        <div class="dashboard-header-wrapper">
            <h3 class="title"><?php echo e(__("Overview")); ?></h3>
        </div>
        <div class="dashboard-item-area">
            <div class="row mb-20-none">
                <div class="col-xxl-3 col-xl-4 col-lg-6 col-md-6 col-sm-12 mb-20">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <span class="sub-title"><?php echo e(__("Total Receive Remittance")); ?></span>
                            <h3 class="title"><?php echo e(getAmount($data['totalReceiveRemittance'],2)); ?> <span class="text--base"><?php echo e(@$baseCurrency->code); ?></span></h3>
                        </div>
                        <div class="dashboard-icon">
                            <i class="fas fa-receipt"></i>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-4 col-lg-6 col-md-6 col-sm-12 mb-20">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <span class="sub-title"><?php echo e(__("Total Send Remittance")); ?></span>
                            <h3 class="title"><?php echo e(getAmount($data['totalSendRemittance'],2)); ?> <span class="text--base"><?php echo e(@$baseCurrency->code); ?></span></h3>
                        </div>
                        <div class="dashboard-icon">
                            <i class="fas fa-paper-plane"></i>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-4 col-lg-6 col-md-6 col-sm-12 mb-20">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <span class="sub-title"><?php echo e(__("Virtual Card")); ?></span>
                            <h3 class="title"><?php echo e(getAmount($data['cardAmount'],2)); ?> <span class="text--base"><?php echo e(@$baseCurrency->code); ?></span></h3>
                        </div>
                        <div class="dashboard-icon">
                            <i class="fas fa-credit-card"></i>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-4 col-lg-6 col-md-6 col-sm-12 mb-20">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <span class="sub-title"><?php echo e(__("Total Bill Pay")); ?></span>
                            <h3 class="title"><?php echo e(getAmount($data['billPay'],2)); ?> <span class="text--base"><?php echo e(@$baseCurrency->code); ?></span></h3>
                        </div>
                        <div class="dashboard-icon">
                            <i class="fas fa-shopping-bag"></i>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-4 col-lg-6 col-md-6 col-sm-12 mb-20">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <span class="sub-title"><?php echo e(__("Total Mobile TopUp")); ?></span>
                            <h3 class="title"><?php echo e(getAmount($data['topUps'],2)); ?> <span class="text--base"><?php echo e(@$baseCurrency->code); ?></span></h3>
                        </div>
                        <div class="dashboard-icon">
                            <i class="fas fa-mobile"></i>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-4 col-lg-6 col-md-6 col-sm-12 mb-20">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <span class="sub-title"><?php echo e(__("Total Withdraw")); ?></span>
                            <h3 class="title"><?php echo e(getAmount($data['withdraw'],2)); ?> <span class="text--base"><?php echo e(@$baseCurrency->code); ?></span></h3>
                        </div>
                        <div class="dashboard-icon">
                            <i class="fas fa-dollar-sign"></i>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-4 col-lg-6 col-md-6 col-sm-12 mb-20">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <span class="sub-title"><?php echo e(__("Total Transactions")); ?></span>
                            <h3 class="title"><?php echo e($data['total_transaction']); ?> <span class="text--base"></span></h3>
                        </div>
                        <div class="dashboard-icon">
                            <i class="fas fa-arrows-alt-h"></i>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-4 col-lg-6 col-md-6 col-sm-12 mb-20">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <span class="sub-title"><?php echo e(__("Total Gift Cards")); ?></span>
                            <h3 class="title"><?php echo e($data['total_gift_cards']); ?> <span class="text--base"></span></h3>
                        </div>
                        <div class="dashboard-icon">
                            <i class="fas fa-gift"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="chart-area mt-30">
        <div class="row mb-20-none">
            <div class="col-xxl-7 col-xl-7 col-lg-7 mb-20">
                <div class="chart-wrapper">
                    <div class="dashboard-header-wrapper">
                        <h4 class="title"><?php echo e(__("Add Money Chart")); ?></h4>
                    </div>
                    <div class="chart-container">
                        <div id="chart1" data-chart_one_data="<?php echo e(json_encode($chartData['chart_one_data'])); ?>" data-month_day="<?php echo e(json_encode($chartData['month_day'])); ?>" class="chart"></div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-5 col-xl-5 col-lg-5 mb-20">
                <div class="chart-wrapper">
                    <div class="dashboard-header-wrapper">
                        <h4 class="title"><?php echo e(__("Withdraw Money")); ?></h4>
                    </div>
                    <div class="chart-container">
                        <div id="chart3" data-chart_three_data="<?php echo e(json_encode($chartData['chart_two_data'])); ?>" data-month_day="<?php echo e(json_encode($chartData['month_day'])); ?>" class="chart"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="dashboard-list-area mt-20">
        <div class="dashboard-header-wrapper">
            <h4 class="title"><?php echo e(__("Latest Transactions")); ?></h4>
            <div class="dashboard-btn-wrapper">
                <div class="dashboard-btn mb-2">
                    <a href="<?php echo e(setRoute('user.transactions.index')); ?>" class="btn--base"><?php echo e(__("View More")); ?></a>
                </div>
            </div>
        </div>
        <div class="dashboard-list-wrapper">
            <?php echo $__env->make('user.components.transaction-log',compact("transactions"), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
<script>
    var chart1 = $('#chart1');
    var chart_one_data = chart1.data('chart_one_data');
    var month_day = chart1.data('month_day');
    var options = {
        series: [
            {
            name: "<?php echo e(__('Pending')); ?>",
            color: "#0C56DB",
            data: chart_one_data.pending_data
            }, {
            name: "<?php echo e(__('Completed')); ?>",
            color: "rgba(0, 227, 150, 0.85)",
            data: chart_one_data.success_data
            }, {
            name: "<?php echo e(__('Canceled')); ?>",
            color: "#dc3545",
            data: chart_one_data.canceled_data
            }, {
            name: "<?php echo e(__('Hold')); ?>",
            color: "#ded7e9",
            data: chart_one_data.hold_data
            }
        ],
        chart: {
            height: 350,
            type: "area",
            toolbar: {
                show: false,
            },
        },
        dataLabels: {
            enabled: false,
        },
        stroke: {
            curve: "smooth",
        },
        xaxis: {
            type: "datetime",
            categories:month_day,
        },
        tooltip: {
            x: {
                format: "dd/MM/yy HH:mm",
            },
        },
    };

    var chart = new ApexCharts(document.querySelector("#chart1"), options);
    chart.render();
//money out
var chart3 = $("#chart3");
var chart_three_data = chart3.data("chart_three_data");
var month_day = chart3.data("month_day");
// apex-chart
var options = {
    series: [
        {
            name: "<?php echo e(__('Pending')); ?>",
            color: "#0C56DB",
            data: chart_three_data.pending_data
            }, {
            name: "<?php echo e(__('Completed')); ?>",
            color: "rgba(0, 227, 150, 0.85)",
            data: chart_three_data.success_data
            }, {
            name: "<?php echo e(__('Canceled')); ?>",
            color: "#dc3545",
            data: chart_three_data.canceled_data
            }, {
            name: "<?php echo e(__('Hold')); ?>",
            color: "#ded7e9",
            data: chart_three_data.hold_data
            }
    ],
    chart: {
        type: "bar",
        height: 350,
        stacked: true,
        toolbar: {
            show: false,
        },
        zoom: {
            enabled: true,
        },
    },
    responsive: [
        {
            breakpoint: 480,
            options: {
                legend: {
                    position: "bottom",
                    offsetX: -10,
                    offsetY: 0,
                },
            },
        },
    ],
    plotOptions: {
        bar: {
            horizontal: false,
            borderRadius: 10,
        },
    },
    xaxis: {
        type: "datetime",
        categories: month_day,
    },
    legend: {
        position: "bottom",
        offsetX: 40,
    },
    fill: {
        opacity: 1,
    },
};

var chart = new ApexCharts(document.querySelector("#chart3"), options);
chart.render();

</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp-8.0.2\htdocs\qrpay\v4.5.0\multiple\resources\views/user/dashboard.blade.php ENDPATH**/ ?>