<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title',['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ]
    ], 'active' => __("Bill Pay Logs")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="table-area">
    <div class="table-wrapper">
        <div class="table-header">
            <h5 class="title"><?php echo e($page_title); ?></h5>
            <?php if(count($transactions) > 0): ?>
            <div class="table-btn-area">
                <a href="<?php echo e(setRoute('admin.remitance.export.data')); ?>" class="btn--base"><i class="fas fa-download me-1"></i><?php echo e(__("Export Data")); ?></a>
            </div>
        <?php endif; ?>
        </div>
        <div class="table-responsive">
            <table class="custom-table">
                <thead>
                    <tr>
                        <th><?php echo e(__("web_trx_id")); ?></th>
                        <th><?php echo e(__("sender")); ?></th>
                        <th><?php echo e(__("Receiver")); ?></th>
                        <th><?php echo e(__("Remittance Type")); ?></th>
                        <th><?php echo e(__(("Send Amount"))); ?></th>
                        <th><?php echo e(__(("Status"))); ?></th>
                        <th><?php echo e(__("Time")); ?></th>
                        <th><?php echo e(__("action")); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                        <tr>
                            <td><?php echo e($item->trx_id); ?></td>
                            <td>
                                <?php if($item->attribute == "SEND"): ?>
                                    <?php if($item->user_id != null): ?>
                                    <a href="<?php echo e(setRoute('admin.users.details',$item->user->username)); ?>"><?php echo e($item->user->fullname); ?></a>
                                    <?php elseif($item->agent_id != null): ?>
                                    <a href="<?php echo e(setRoute('admin.agents.details',$item->creator->username)); ?>"><?php echo e($item->creator->fullname); ?></a>
                                    <?php elseif($item->merchant_id != null): ?>
                                    <a href="<?php echo e(setRoute('admin.merchants.details',$item->creator->username)); ?>"><?php echo e($item->creator->fullname); ?></a>
                                    <?php endif; ?>
                                <?php else: ?>
                                <span><?php echo e($item->details->sender->fullname); ?></span>
                                <?php endif; ?>

                            </td>
                            <td>
                                <?php if($item->attribute == "RECEIVED"): ?>
                                    <?php if($item->user_id != null): ?>
                                        <a href="<?php echo e(setRoute('admin.users.details',$item->user->username)); ?>"><?php echo e($item->user->fullname); ?></a>
                                    <?php elseif($item->agent_id != null): ?>
                                        <a href="<?php echo e(setRoute('admin.agents.details',$item->creator->username)); ?>"><?php echo e($item->creator->fullname); ?></a>
                                    <?php elseif($item->merchant_id != null): ?>
                                        <a href="<?php echo e(setRoute('admin.merchants.details',$item->creator->username)); ?>"><?php echo e($item->creator->fullname); ?></a>
                                    <?php endif; ?>
                                <?php else: ?>

                                    <?php if($item->user_id != null): ?>
                                        <span><?php echo e(@$item->details->receiver->firstname); ?> <?php echo e(@$item->details->receiver->lastname); ?></span>
                                    <?php elseif($item->agent_id != null): ?>
                                    <span><?php echo e(@$item->details->receiver_recipient->firstname); ?> <?php echo e(@$item->details->receiver_recipient->lastname); ?></span>
                                    <?php endif; ?>
                                <?php endif; ?>

                            </td>
                            <td >
                                <?php if( @$item->details->remitance_type == "wallet-to-wallet-transfer"): ?>
                                    <span class="fw-bold"> <?php echo e(@$basic_settings->site_name); ?> <?php echo e(__("Wallet")); ?> </span>
                                    <?php else: ?>
                                    <span class="fw-bold"> <?php echo e(ucwords(str_replace('-', ' ', @$item->details->remitance_type))); ?> </span>

                                <?php endif; ?>
                               </td>
                            
                            <td><?php echo e(get_amount($item->request_amount,$item->details->charges->sender_cur_code??get_default_currency_code())); ?> </td>
                            <td>
                                <span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?></span>
                            </td>
                            <td><?php echo e($item->created_at->format('d-m-y h:i:s A')); ?></td>
                            <td>
                                <?php echo $__env->make('admin.components.link.info-default',[
                                    'href'          => setRoute('admin.remitance.details', $item->id),
                                    'permission'    => "admin.remitance.details",
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                         <?php echo $__env->make('admin.components.alerts.empty',['colspan' => 8], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php echo e(get_paginate($transactions)); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/admin/sections/remitance/index.blade.php ENDPATH**/ ?>