<?php $__env->startPush('css'); ?>
    <style>
        .copy-button {
            cursor: pointer;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('merchant.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("merchant.dashboard"),
        ]
    ], 'active' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="body-wrapper">
    <div class="row mb-20-none">
        <div class="col-xl-12 col-lg-12 mb-20">
            <div class="custom-card mt-10">
                <div class="dashboard-header-wrapper">
                    <h5 class="title"><?php echo e(__("developer API")); ?></h5>
                </div>
                <?php if(auth()->user()->developerApi): ?>
                <div class="row justify-content-center">
                    <div class="col-lg-12">
                        <div class="dash-payment-item-wrapper">
                            <div class="dash-payment-item active">
                                <div class="dash-payment-title-area justify-content-end align-items-center d-sm-flex d-block">
                                    <button type="button" class="btn--base mt-3 mt-sm-0 api-kys-btn"><?php echo e(__("Create Api Keys")); ?></button>
                                </div>

                                <div class="table-responsive">
                                    <table class="custom-table">
                                        <thead>
                                            <tr>
                                                <th><?php echo e(__("name")); ?></th>
                                                <th><?php echo e(__('Client ID')); ?></th>
                                                <th><?php echo e(__('Secret ID')); ?></th>
                                                <th><?php echo e(__('Mode')); ?></th>
                                                <th><?php echo e(__('Created At')); ?></th>
                                                <th><?php echo e(__('action')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $apis ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <tr>
                                                    <td><?php echo e($item->name); ?></td>
                                                    <td>
                                                        <div class="secret-key mt-3">
                                                            <span class="fw-bold"><?php echo e(textLength($item->client_id, 20)); ?></span>
                                                            <div class="copy-text copy-btn copytext" data-copy-value="<?php echo e($item->client_id); ?>"><i class="las la-copy"></i></div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="secret-key mt-3">
                                                            <span class="fw-bold"><?php echo e(textLength($item->client_secret, 20)); ?></span>
                                                            <div class="copy-text copy-btn copytext" data-copy-value="<?php echo e($item->client_secret); ?>"><i class="las la-copy"></i></div>
                                                        </div>
                                                    </td>
                                                    <td><?php echo e($item->mode); ?></td>
                                                    <td><?php echo e(dateFormat('d M Y , h:i:s A', $item->created_at)); ?></td>
                                                    <td>
                                                        <button type="button" class="btn--base btn text-light active-deactive-btn" data-id="<?php echo e($item->id); ?>"><i class="las la-check-circle"></i></button>
                                                        <button type="button" class="btn--danger btn text-light delete-btn" data-id="<?php echo e($item->id); ?>"><i class="las la-trash"></i></button>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <?php echo $__env->make('admin.components.alerts.empty2',['colspan' => 6], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>

                                <nav>
                                    <?php echo e($apis->links()); ?>

                                 </nav>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start fund virtual card modal
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<div class="modal fade" id="apiKeysModal" tabindex="-1" aria-labelledby="apiKyesModalLabel" aria-hidden="true">
    <div class="modal-dialog">
    <div class="modal-content overflow-hidden">
        <div class="modal-header">
        <h5 class="modal-title" id="apiKyesModalLabel"><?php echo e(__('Create New Api Keys')); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body p-0">
            <div class="dash-payment-item-wrapper">
                <div class="dash-payment-item active mb-0 rounded-0">
                    <div class="row mt-20">
                        <form class="card-form" action="<?php echo e(setRoute('merchant.developer.api.generate.keys')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="id">
                            <div class="col-xl-12 col-lg-12 form-group">
                                <label><?php echo e(__("name")); ?> <span class="text--base">*</span></label>
                                <div class="input-group">
                                    <input type="text" class="form--control" required placeholder="<?php echo e(__("Enter Name")); ?>" name="name" value="<?php echo e(old("name")); ?>">
                                </div>
                            </div>
                            <div class="col-xl-12 col-lg-12 form-group">
                                <button type="submit" class="btn--base w-100 btn-loading"><?php echo e(__("Create")); ?><i class="las la-plus-circle ms-1"></i></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
</div>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End fund virtual card modal
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(".active-deactive-btn").click(function(){
            var actionRoute =  "<?php echo e(setRoute('merchant.developer.api.mode.update')); ?>";
            var target      = $(this).data('id');
            var btnText     = "<?php echo e(__('Change')); ?>";
            var message     = "<?php echo e(__('Are you sure to change mode')); ?>"+"?";
            openAlertModal(actionRoute,target,message,btnText,"POST");
        });
        $(".delete-btn").click(function(){
            var actionRoute =  "<?php echo e(setRoute('merchant.developer.api.delete.keys')); ?>";
            var target      = $(this).data('id');
            var btnText     = "<?php echo e(__('Delete')); ?>";
            var message     = "<?php echo e(__('delete_text')); ?>"+"?";
            openAlertModal(actionRoute,target,message,btnText,"POST");
        });

        //copy keys
        document.addEventListener('DOMContentLoaded', function () {
            document.querySelectorAll('.copy-btn').forEach(function (copyBtn) {
                copyBtn.addEventListener('click', function () {
                    var copyValue = this.getAttribute('data-copy-value');
                    var tempInput = document.createElement('input');
                    tempInput.value = copyValue;
                    document.body.appendChild(tempInput);
                    tempInput.select();
                    tempInput.setSelectionRange(0, 99999); // For mobile devices
                    document.execCommand('copy');
                    document.body.removeChild(tempInput);
                    var message     = "<?php echo e(__('Copied Successful')); ?>";
                    throwMessage('success',[message]);
                });
            });
        });

        $('.api-kys-btn').on('click', function () {
            var modal = $('#apiKeysModal');
            modal.modal('show');
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('merchant.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp-8.0.2\htdocs\qrpay\v4.5.0\full_project\resources\views/merchant/sections/api/index.blade.php ENDPATH**/ ?>