<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title', ['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' =>  __($page_title),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="custom-card">
        <div class="card-header">
            <h6 class="title"><?php echo e(__($page_title)); ?></h6>
        </div>
        <div class="card-body">
            <form class="card-form">
                <div class="row align-items-center mb-10-none">
                    <div class="col-xl-4 col-lg-4 form-group">
                        <ul class="user-profile-list-two">
                            <li class="one"><?php echo e(__("Date")); ?>: <span><?php echo e(dateFormat('d M y h:i:s A', $data->created_at)); ?></span></li>
                            <li class="two"><?php echo e(__("web_trx_id")); ?>: <span><?php echo e(@$data->trx_id); ?></span></li>
                            <li class="three"><?php echo e(__("Email")); ?>: <span>
                                <?php if($data->user_id != null): ?>
                                    <a href="<?php echo e(setRoute('admin.users.details',$data->creator->username)); ?>"><?php echo e($data->creator->email); ?> (<?php echo e(__("USER")); ?>)</a>
                                <?php elseif($data->merchant_id != null): ?>
                                    <a href="<?php echo e(setRoute('admin.merchants.details',$data->creator->username)); ?>"><?php echo e($data->creator->email); ?> (<?php echo e(__("MERCHANT")); ?>)</a>
                                <?php endif; ?>
                                </span></li>
                            <li class="four"><?php echo e(__("Method")); ?>: <span><?php echo e(@$data->type); ?></span></li>
                            <li class="five"><?php echo e(__("Amount")); ?>: <span><?php echo e(get_amount(@$data->request_amount,@$data->details->charge_calculation->receiver_currency_code)); ?> </span></li>
                        </ul>
                    </div>
                    <div class="col-xl-4 col-lg-4 form-group">
                        <div class="user-profile-thumb">
                            <img src="<?php echo e(@$data->creator->userImage); ?>" alt="payment">
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 form-group">
                        <ul class="user-profile-list two">
                            <li class="one"><?php echo e(__("Rate")); ?>: <span>1 <?php echo e(get_default_currency_code()); ?> = <?php echo e(get_amount(@$data->details->charge_calculation->r_exchange_rate,@$data->details->charge_calculation->receiver_currency_code)); ?> <?php echo e(@$data->currency->currency_code); ?></span></li>
                            <li class="two"><?php echo e(__("Conversion Payable")); ?>: <span><?php echo e(get_amount(@$data->details->charge_calculation->request_amount_admin,@$data->details->charge_calculation->base_currency_code)); ?></span></li>
                            <li class="three"><?php echo e(__("Charge")); ?>: <span><?php echo e(get_amount(@$data->charge->total_charge,@$data->details->charge_calculation->receiver_currency_code)); ?></span></li>
                            <li class="four"><?php echo e(__("Payable Amount")); ?>: <span><?php echo e(get_amount(@$data->payable,@$data->details->charge_calculation->receiver_currency_code)); ?> </span></li>
                            <li class="five"><?php echo e(__("Status")); ?>:  <span class="<?php echo e(@$data->stringStatus->class); ?>"><?php echo e(__(@$data->stringStatus->value)); ?></span></li>
                        </ul>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="custom-card mt-15">
        <div class="card-header">
            <h6 class="title text-bold"><?php echo e(__("Payment Information")); ?></h6>
            <h6 class="title "><?php echo e(__("Payment Type")); ?>: <span class="text-bold fw-bold text-success"> <?php echo e(ucwords(str_replace('_',' ',$data->details->payment_type??__("Card Payment")) )); ?> </span></h6>
        </div>
        <div class="card-body">

            <ul class="product-sales-info">
                <?php if(isset($data->details->payment_type) && $data->details->payment_type == payment_gateway_const()::TYPE_CARD_PAYMENT): ?>
                    <li>
                        <span class="kyc-title"><?php echo e(__("Sender Email")); ?>:</span>
                        <span><?php echo e(@$data->details->email); ?></span>
                    </li>
                    <li>
                        <span class="kyc-title"><?php echo e(__("Card Holder Name")); ?>:</span>
                        <span><?php echo e(@$data->details->card_name); ?></span>
                    </li>
                    <li>
                        <span class="kyc-title"><?php echo e(__("Sender Card Number")); ?>:</span>
                        <span>**** **** **** <?php echo e(@$data->details->last4_card); ?></span>
                    </li>

                <?php elseif(isset($data->details->payment_type) && $data->details->payment_type == payment_gateway_const()::TYPE_GATEWAY_PAYMENT): ?>
                <li>
                    <span class="kyc-title"><?php echo e(__("Payment Gateway")); ?>:</span>
                    <span><?php echo e($data->details->currency->name); ?></span>
                </li>

                <?php elseif(isset($data->details->payment_type) && $data->details->payment_type == payment_gateway_const()::TYPE_WALLET_SYSTEM): ?>
                <li>
                    <span class="kyc-title"><?php echo e(__("User Type")); ?>:</span>
                    <span><?php echo e("USER"); ?></span>
                </li>
                <li>
                    <span class="kyc-title"><?php echo e(__("Full Name")); ?>:</span>
                    <a href="<?php echo e(setRoute('admin.users.details',$data->details->sender->username)); ?>">
                        <span><?php echo e($data->details->sender->fullname); ?></span>
                    </a>
                </li>
                <li>
                    <span class="kyc-title"><?php echo e(__("Sender Username")); ?>:</span>
                    <a href="<?php echo e(setRoute('admin.users.details',$data->details->sender->username)); ?>">
                        <span><?php echo e($data->details->sender->username); ?></span>
                    </a>
                </li>
                <li>
                    <span class="kyc-title"><?php echo e(__("Sender Email")); ?>:</span>
                    <a href="<?php echo e(setRoute('admin.users.details',$data->details->sender->username)); ?>">
                        <span><?php echo e($data->details->sender->email); ?></span>
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/admin/sections/payment-link/details.blade.php ENDPATH**/ ?>