<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title',['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ]
    ], 'active' => __("Create User Group")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<form class="card-form" method="POST" action="<?php echo e(setRoute('admin.setup.group.users.store')); ?>">
    <?php echo csrf_field(); ?>
    <div class="custom-card mb-10">
        <div class="card-header">
            <h6 class="title"><?php echo e(__("Basic Informations")); ?></h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-xl-6 col-lg-6 mb-10">
                    <div class="custom-inner-card">
                        <div class="card-inner-header">
                            <h5 class="title"><?php echo e(__("Group Name")); ?></h5>
                        </div>
                        <div class="card-inner-body">
                            <div class="row">
                                <div class="col-xl-12 col-lg-12 form-group">
                                    <input type="text" placeholder="<?php echo e(__('Enter Group Name')); ?>" name="group_name" class="form--control  " value="<?php echo e(old('group_name')); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 mb-10">
                    <div class="custom-inner-card">
                        <div class="card-inner-header">
                            <h5 class="title"><?php echo e(__("Assign Users")); ?></h5>
                        </div>
                        <div class="card-inner-body">


                            <div class="row">
                                <div class="col-xl-12 col-lg-12 form-group">
                                    <select name="users[]" multiple id="" class=" form--control select2-auto-tokenize" data-placeholder="<?php echo e(__("Select Users")); ?>">
                                        <?php $__currentLoopData = $allUsers ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(in_array($user->id,$assignedGroupUsers)): ?>
                                            <?php else: ?>
                                            <option value="<?php echo e($user->id); ?>"><?php echo e(ucwords($user->fullname)); ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php $__currentLoopData = $transaction_charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo $__env->make('admin.components.charge-group.user-trx-settings-charge-block',[
            'title'         => $item->title,
            'data'          => $item,
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <div class="row mb-10-none">
        <div class="col-xl-12 col-lg-12 form-group">
            <?php echo $__env->make('admin.components.button.form-btn',[
                'text'          => __("Create Group"),
                'class'         => "w-100 btn-loading",
                'permission'    => "admin.setup.group.users.create",
            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/admin/sections/setup-group/user/create.blade.php ENDPATH**/ ?>